﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/news/detail/ipc/news_INewsService.sfdl.h>
#include <nn/news/detail/ipc/news_INewlyArrivedEventHolder.sfdl.h>
#include <nn/news/detail/ipc/news_INewsDataService.sfdl.h>
#include <nn/news/detail/ipc/news_INewsDatabaseService.sfdl.h>
#include <nn/news/detail/ipc/news_IOverwriteEventHolder.sfdl.h>

namespace nn { namespace news { namespace detail { namespace ipc {

/*!
    @brief      IPC サービスの初期化を行います。
*/
void Initialize() NN_NOEXCEPT;

/*!
    @brief      IPC サービスの終了処理を行います。
*/
void Finalize() NN_NOEXCEPT;

/*!
    @brief      NewsService を作成します。

    @param[out] outService  NewsService。

    @return     処理結果。
*/
nn::Result CreateNewsService(INewsService** outService) NN_NOEXCEPT;

/*!
    @brief      NewlyArrivedEventHolder を作成します。

    @param[out] outHolder   NewlyArrivedEventHolder。

    @return     処理結果。
*/
nn::Result CreateNewlyArrivedEventHolder(detail::ipc::INewlyArrivedEventHolder** outHolder) NN_NOEXCEPT;

/*!
    @brief      OverwriteEventHolder を作成します。

    @param[out] outHolder   OverwriteEventHolder。

    @return     処理結果。
*/
nn::Result CreateOverwriteEventHolder(detail::ipc::IOverwriteEventHolder** outHolder) NN_NOEXCEPT;

/*!
    @brief      NewsDataService を作成します。

    @param[out] outService  NewsDataService。

    @return     処理結果。
*/
nn::Result CreateNewsDataService(detail::ipc::INewsDataService** outService) NN_NOEXCEPT;

/*!
    @brief      NewsDatabaseService を作成します。

    @param[out] outService  NewsDatabaseService。

    @return     処理結果。
*/
nn::Result CreateNewsDatabaseService(detail::ipc::INewsDatabaseService** outService) NN_NOEXCEPT;

}}}}
