﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief グローバル IP アドレス取得 API
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/netdiag/netdiag_GlobalIpAddressTypes.h>

namespace nn { namespace netdiag {

    /**
     * @name    グローバル IP アドレス取得
     * @{
     */

    /**
     * @brief       グローバル IP アドレスを取得します。
     *
     * @param[out]  pGlobalIpAddress    グローバル IP アドレスデータを格納するポインタ
     *
     * @retresult
     *      @handleresult{ResultFailedNetwork, ネットワーク接続に失敗してグローバル IP アドレスを取得できませんでした}
     *      @handleresult{ResultInterrupted, InterruptGetGlobalIpAddess() によって処理が中断されました。}
     * @endretresult
     *
     * @pre
     *  - nifm ライブラリが初期化済
     *  - socket ライブラリが初期化済
     *  - libcurl ライブラリが初期化済
     *
     * @details
     *   時間サーバーにアクセスし、グローバル IP アドレスを取得します。
     *   サーバーからデータダウンロードするため、この関数は
     *   ある程度の時間、処理をブロックする可能性があります。
     */
    Result GetGlobalIpAddress( GlobalIpAddress* pGlobalIpAddress ) NN_NOEXCEPT;

    /**
     * @brief   グローバル IP アドレスの取得の中断指示を出します。
     *
     * @details
     *    nn::netdiag::GetGlobalIpAddress() の 処理を中断します。
     *    この関数でブロックされることはありません。
     *    グローバル IP アドレス取得を行っていないときにこの関数を呼んだ場合、何も行いません。
     */
     void InterruptGetGlobalIpAddress() NN_NOEXCEPT;

    /**
     * @}
     */

}} // nn::netdiag
