﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief nn::netdiag の型定義
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace netdiag {

    /**
     * @brief ネットワーク帯域を表します。
     * @details
     *  単位は bytes/sec です。
     */
    typedef double BandWidth;

    /**
     * @brief アップロード帯域計測のタイムアウト値です。
     * @details
     *  単位は ミリ秒 です。
     *  nn::netdiag::MeasureBandWidthForUpload() のタイムアウト値として使用されます。
     */
    const uint32_t TimeoutForUploadMeasuring = 10 * 1000; // 10秒

    /**
     * @brief ダウンロード帯域計測のタイムアウト値です。
     * @details
     *  単位は ミリ秒 です。
     *  nn::netdiag::MeasureBandWidthForDownload() のタイムアウト値として使用されます。
     */
    const uint32_t TimeoutForDownloadMeasuring = 10 * 1000; // 10秒

}} // nn::netdiag
