﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <climits>
#include <nn/mmnv/mmnv_ModuleId.h>

namespace nn     {
namespace mmnv    {

/**
    @brief      Number of priorities supported by FGM
*/
const int  NumberOfPriorities  = 10;

/**
    @brief      FGM priority
*/
typedef uint32_t Priority;

/**
    @brief      Priority definitions.
*/
enum PriorityDefinitions
{
    /**
        @brief  Highest priority, overrides all other requests.
    */
    Priority_Highest = 0,

    Priority_Thermal = Priority_Highest,

    /**
        @brief Default priority, should be used by most clients.
    */
    Priority_Default = 8,

    Priority_Lowest  = NumberOfPriorities - 1,
};

/**
    @brief      Basic type defining operational point of a PM resource.
*/
typedef uint32_t Setting;

/**
    @brief      Min and Max constants.
*/
enum SettingDefinitions
{
    /**
        @brief      Minimum @ref Setting supported by PM resource.
        @details    When client wants to limit operating range to the minimum setting
                    that is supported by the PM resource, it can pass Setting_Min in place
                    of the actual value. FGM will replace Setting_Min with the actual
                    minimum value that resource supports.
    */
    Setting_Min = 0,

    /**
        @brief      Maximum @ref Setting supported by PM resource.
        @details    When client wants to limit operating range to the maximum setting
                    that is supported by the PM resource, it can pass Setting_Max in place
                    of the actual value. FGM will replace Setting_Max with the actual
                    maximum value that resource supports.
    */
    Setting_Max = UINT_MAX,
};

/**
    @brief      Maximum number of simultanous FGM requests for each priority.
    @details    Each process has a limit on the number of simultanious requests
                at each priority. When this limit is exceeded, an error will be
                returned from Initialize() call.
*/
const int MaximumRequestsPerPriority = 40;

}}
