﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn     {
namespace mmnv    {

/**
    @brief      Supported modules.
*/
enum Module
{
    /**
        @brief CPU clock.
    */
    Module_Cpu,

    /**
        @brief GPU clock.
    */
    Module_Gpu,

    /**
        @brief Memory clock.
    */
    Module_Emc,

    /**
        @brief SysBus clock.
    */
    Module_SysBus,

    /**
        @brief Mselect clock.
    */
    Module_Mselect,

    /**
        @brief Nvdec clock.
    */
    Module_Nvdec,

    /**
        @brief Nvenc clock.
    */
    Module_Nvenc,

    /**
        @brief Nvjpg clock.
    */
    Module_Nvjpg,

    Module_Test,

    Module_NumModule
};

}}
