﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mii/detail/service/mii_ServiceCommon.h>

#include <nn/mii/detail/mii_DatabaseImpl.h>
#include <nn/mii/detail/mii_DatabaseFile.h>     // TODO
#include <nn/mii/detail/mii_ImageDatabaseImpl.h>
#include <nn/mii/detail/service/mii_HipcServerManager.h>

#include <nn/util/util_TypedStorage.h>


namespace nn
{
namespace mii
{
namespace detail
{

class ServiceProvider
{
    friend class ServiceProviderClient;
    friend class StaticServiceInterface;
    friend class ImageServiceProviderClient;
    friend class ImageDatabaseServiceInterface;

private:
    class GeneralArranger
    {
    public:
        GeneralArranger() NN_NOEXCEPT;
        ~GeneralArranger() NN_NOEXCEPT;
    };

private:
    // ServiceProvider のメンバになるクラスは、コンストラクタの引数でポインタを与えられても
    // コンストラクタ内では、変数への格納以外、ポインタに対して操作をおこなってはいけない
    GeneralArranger m_GeneralArranger;

    nn::util::TypedStorage<DatabaseFile, sizeof(DatabaseFile), NN_ALIGNOF(DatabaseFile)> m_DatabaseImplStorage;
    DatabaseImpl m_DatabaseImpl;

    HipcServerManager m_HipcServerManager;

    ImageDatabaseImpl m_ImageDatabaseImpl;

public:
    ServiceProvider() NN_NOEXCEPT;
    ~ServiceProvider() NN_NOEXCEPT;

    nn::Result Start() NN_NOEXCEPT;
    nn::Result RequestStopServer() NN_NOEXCEPT;
};

}
}
}
