﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/mii/mii_Common.h>
#include <nn/mii/mii_ParamCommon.h>
#include <nn/mii/mii_PrivateCommon.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace mii { namespace detail { // NOLINT(whitespace/braces)

class IDatabaseService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDatabaseService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDatabaseService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsUpdated, (::nn::sf::Out<bool> outIsUpdated, ::std::int32_t sourceFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsFullDatabase, (::nn::sf::Out<bool> outIsFullDatabase))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCount, (::nn::sf::Out<::std::int32_t> outCount, ::std::int32_t sourceFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::CharInfoElement>& outElements, ::std::int32_t sourceFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Get1, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::CharInfo>& outElements, ::std::int32_t sourceFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateLatest, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, const ::nn::mii::CharInfo& info, ::std::int32_t sourceFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BuildRandom, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, ::std::int32_t age, ::std::int32_t gender, ::std::int32_t race))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BuildDefault, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, ::std::int32_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Get2, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::StoreDataElement>& outElements, ::std::int32_t sourceFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Get3, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::StoreData>& outElements, ::std::int32_t sourceFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateLatest1, (::nn::sf::Out<::nn::mii::StoreData> outStoreData, const ::nn::mii::StoreData& storeData, ::std::int32_t sourceFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FindIndex, (::nn::sf::Out<::std::int32_t> outIndex, const ::nn::mii::CreateId& id, bool enabledSpecialMii))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Move, (::std::int32_t newIndex, const ::nn::mii::CreateId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddOrReplace, (const ::nn::mii::StoreData& storeData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Delete, (const ::nn::mii::CreateId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DestroyFile)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteFile)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Format)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Import, (const ::nn::sf::InBuffer& inBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Export, (const ::nn::sf::OutBuffer& outBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsBrokenDatabaseWithClearFlag, (::nn::sf::Out<bool> outIsBrokenDatabase))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetIndex, (::nn::sf::Out<::std::int32_t> outIndex, const ::nn::mii::CharInfo& info))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInterfaceVersion, (::std::int32_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Convert, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, const ::nn::mii::Ver3StoreData& ver3StoreData))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDatabaseService)

        ::nn::Result IsUpdated(::nn::sf::Out<bool> outIsUpdated, ::std::int32_t sourceFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsUpdated, (outIsUpdated, sourceFlags));
        }

        ::nn::Result IsFullDatabase(::nn::sf::Out<bool> outIsFullDatabase) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsFullDatabase, (outIsFullDatabase));
        }

        ::nn::Result GetCount(::nn::sf::Out<::std::int32_t> outCount, ::std::int32_t sourceFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCount, (outCount, sourceFlags));
        }

        ::nn::Result Get(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::CharInfoElement>& outElements, ::std::int32_t sourceFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Get, (outCount, outElements, sourceFlags));
        }

        ::nn::Result Get1(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::CharInfo>& outElements, ::std::int32_t sourceFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Get1, (outCount, outElements, sourceFlags));
        }

        ::nn::Result UpdateLatest(::nn::sf::Out<::nn::mii::CharInfo> outInfo, const ::nn::mii::CharInfo& info, ::std::int32_t sourceFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateLatest, (outInfo, info, sourceFlags));
        }

        ::nn::Result BuildRandom(::nn::sf::Out<::nn::mii::CharInfo> outInfo, ::std::int32_t age, ::std::int32_t gender, ::std::int32_t race) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BuildRandom, (outInfo, age, gender, race));
        }

        ::nn::Result BuildDefault(::nn::sf::Out<::nn::mii::CharInfo> outInfo, ::std::int32_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BuildDefault, (outInfo, index));
        }

        ::nn::Result Get2(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::StoreDataElement>& outElements, ::std::int32_t sourceFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Get2, (outCount, outElements, sourceFlags));
        }

        ::nn::Result Get3(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::StoreData>& outElements, ::std::int32_t sourceFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Get3, (outCount, outElements, sourceFlags));
        }

        ::nn::Result UpdateLatest1(::nn::sf::Out<::nn::mii::StoreData> outStoreData, const ::nn::mii::StoreData& storeData, ::std::int32_t sourceFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateLatest1, (outStoreData, storeData, sourceFlags));
        }

        ::nn::Result FindIndex(::nn::sf::Out<::std::int32_t> outIndex, const ::nn::mii::CreateId& id, bool enabledSpecialMii) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FindIndex, (outIndex, id, enabledSpecialMii));
        }

        ::nn::Result Move(::std::int32_t newIndex, const ::nn::mii::CreateId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Move, (newIndex, id));
        }

        ::nn::Result AddOrReplace(const ::nn::mii::StoreData& storeData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddOrReplace, (storeData));
        }

        ::nn::Result Delete(const ::nn::mii::CreateId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Delete, (id));
        }

        ::nn::Result DestroyFile() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DestroyFile);
        }

        ::nn::Result DeleteFile() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteFile);
        }

        ::nn::Result Format() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Format);
        }

        ::nn::Result Import(const ::nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Import, (inBuffer));
        }

        ::nn::Result Export(const ::nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Export, (outBuffer));
        }

        ::nn::Result IsBrokenDatabaseWithClearFlag(::nn::sf::Out<bool> outIsBrokenDatabase) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsBrokenDatabaseWithClearFlag, (outIsBrokenDatabase));
        }

        ::nn::Result GetIndex(::nn::sf::Out<::std::int32_t> outIndex, const ::nn::mii::CharInfo& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetIndex, (outIndex, info));
        }

        ::nn::Result SetInterfaceVersion(::std::int32_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInterfaceVersion, (version));
        }

        ::nn::Result Convert(::nn::sf::Out<::nn::mii::CharInfo> outInfo, const ::nn::mii::Ver3StoreData& ver3StoreData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Convert, (outInfo, ver3StoreData));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDatabaseService
    {
    public:
        nn::Result IsUpdated(nn::sf::Out<bool> outIsUpdated, std::int32_t sourceFlags) NN_NOEXCEPT;
        nn::Result IsFullDatabase(nn::sf::Out<bool> outIsFullDatabase) NN_NOEXCEPT;
        nn::Result GetCount(nn::sf::Out<std::int32_t> outCount, std::int32_t sourceFlags) NN_NOEXCEPT;
        nn::Result Get(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::CharInfoElement>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT;
        nn::Result Get1(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::CharInfo>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT;
        nn::Result UpdateLatest(nn::sf::Out<nn::mii::CharInfo> outInfo, const nn::mii::CharInfo& info, std::int32_t sourceFlags) NN_NOEXCEPT;
        nn::Result BuildRandom(nn::sf::Out<nn::mii::CharInfo> outInfo, std::int32_t age, std::int32_t gender, std::int32_t race) NN_NOEXCEPT;
        nn::Result BuildDefault(nn::sf::Out<nn::mii::CharInfo> outInfo, std::int32_t index) NN_NOEXCEPT;
        nn::Result Get2(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::StoreDataElement>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT;
        nn::Result Get3(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::StoreData>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT;
        nn::Result UpdateLatest1(nn::sf::Out<nn::mii::StoreData> outStoreData, const nn::mii::StoreData& storeData, std::int32_t sourceFlags) NN_NOEXCEPT;
        nn::Result FindIndex(nn::sf::Out<std::int32_t> outIndex, const nn::mii::CreateId& id, bool enabledSpecialMii) NN_NOEXCEPT;
        nn::Result Move(std::int32_t newIndex, const nn::mii::CreateId& id) NN_NOEXCEPT;
        nn::Result AddOrReplace(const nn::mii::StoreData& storeData) NN_NOEXCEPT;
        nn::Result Delete(const nn::mii::CreateId& id) NN_NOEXCEPT;
        nn::Result DestroyFile() NN_NOEXCEPT;
        nn::Result DeleteFile() NN_NOEXCEPT;
        nn::Result Format() NN_NOEXCEPT;
        nn::Result Import(const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
        nn::Result Export(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        nn::Result IsBrokenDatabaseWithClearFlag(nn::sf::Out<bool> outIsBrokenDatabase) NN_NOEXCEPT;
        nn::Result GetIndex(nn::sf::Out<std::int32_t> outIndex, const nn::mii::CharInfo& info) NN_NOEXCEPT;
        nn::Result SetInterfaceVersion(std::int32_t version) NN_NOEXCEPT;
        nn::Result Convert(nn::sf::Out<nn::mii::CharInfo> outInfo, const nn::mii::Ver3StoreData& ver3StoreData) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result IsUpdated(nn::sf::Out<bool> outIsUpdated, std::int32_t sourceFlags) NN_NOEXCEPT;
    nn::Result IsFullDatabase(nn::sf::Out<bool> outIsFullDatabase) NN_NOEXCEPT;
    nn::Result GetCount(nn::sf::Out<std::int32_t> outCount, std::int32_t sourceFlags) NN_NOEXCEPT;
    nn::Result Get(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::CharInfoElement>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT;
    nn::Result Get1(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::CharInfo>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT;
    nn::Result UpdateLatest(nn::sf::Out<nn::mii::CharInfo> outInfo, const nn::mii::CharInfo& info, std::int32_t sourceFlags) NN_NOEXCEPT;
    nn::Result BuildRandom(nn::sf::Out<nn::mii::CharInfo> outInfo, std::int32_t age, std::int32_t gender, std::int32_t race) NN_NOEXCEPT;
    nn::Result BuildDefault(nn::sf::Out<nn::mii::CharInfo> outInfo, std::int32_t index) NN_NOEXCEPT;
    nn::Result Get2(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::StoreDataElement>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT;
    nn::Result Get3(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::StoreData>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT;
    nn::Result UpdateLatest1(nn::sf::Out<nn::mii::StoreData> outStoreData, const nn::mii::StoreData& storeData, std::int32_t sourceFlags) NN_NOEXCEPT;
    nn::Result FindIndex(nn::sf::Out<std::int32_t> outIndex, const nn::mii::CreateId& id, bool enabledSpecialMii) NN_NOEXCEPT;
    nn::Result Move(std::int32_t newIndex, const nn::mii::CreateId& id) NN_NOEXCEPT;
    nn::Result AddOrReplace(const nn::mii::StoreData& storeData) NN_NOEXCEPT;
    nn::Result Delete(const nn::mii::CreateId& id) NN_NOEXCEPT;
    nn::Result DestroyFile() NN_NOEXCEPT;
    nn::Result DeleteFile() NN_NOEXCEPT;
    nn::Result Format() NN_NOEXCEPT;
    nn::Result Import(const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
    nn::Result Export(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result IsBrokenDatabaseWithClearFlag(nn::sf::Out<bool> outIsBrokenDatabase) NN_NOEXCEPT;
    nn::Result GetIndex(nn::sf::Out<std::int32_t> outIndex, const nn::mii::CharInfo& info) NN_NOEXCEPT;
    nn::Result SetInterfaceVersion(std::int32_t version) NN_NOEXCEPT;
    nn::Result Convert(nn::sf::Out<nn::mii::CharInfo> outInfo, const nn::mii::Ver3StoreData& ver3StoreData) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::mii::detail::IDatabaseService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUpdated, (::nn::sf::Out<bool> outIsUpdated, ::std::int32_t sourceFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsUpdated, (outIsUpdated, sourceFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsFullDatabase, (::nn::sf::Out<bool> outIsFullDatabase))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsFullDatabase, (outIsFullDatabase));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCount, (::nn::sf::Out<::std::int32_t> outCount, ::std::int32_t sourceFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCount, (outCount, sourceFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::CharInfoElement>& outElements, ::std::int32_t sourceFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Get, (outCount, outElements, sourceFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get1, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::CharInfo>& outElements, ::std::int32_t sourceFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Get1, (outCount, outElements, sourceFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateLatest, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, const ::nn::mii::CharInfo& info, ::std::int32_t sourceFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateLatest, (outInfo, info, sourceFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BuildRandom, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, ::std::int32_t age, ::std::int32_t gender, ::std::int32_t race))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BuildRandom, (outInfo, age, gender, race));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BuildDefault, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, ::std::int32_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BuildDefault, (outInfo, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get2, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::StoreDataElement>& outElements, ::std::int32_t sourceFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Get2, (outCount, outElements, sourceFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get3, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::StoreData>& outElements, ::std::int32_t sourceFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Get3, (outCount, outElements, sourceFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateLatest1, (::nn::sf::Out<::nn::mii::StoreData> outStoreData, const ::nn::mii::StoreData& storeData, ::std::int32_t sourceFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateLatest1, (outStoreData, storeData, sourceFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindIndex, (::nn::sf::Out<::std::int32_t> outIndex, const ::nn::mii::CreateId& id, bool enabledSpecialMii))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FindIndex, (outIndex, id, enabledSpecialMii));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Move, (::std::int32_t newIndex, const ::nn::mii::CreateId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Move, (newIndex, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddOrReplace, (const ::nn::mii::StoreData& storeData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddOrReplace, (storeData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Delete, (const ::nn::mii::CreateId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Delete, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroyFile)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DestroyFile);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteFile)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteFile);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Format)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Format);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Import, (const ::nn::sf::InBuffer& inBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Import, (inBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Export, (const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Export, (outBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsBrokenDatabaseWithClearFlag, (::nn::sf::Out<bool> outIsBrokenDatabase))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsBrokenDatabaseWithClearFlag, (outIsBrokenDatabase));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndex, (::nn::sf::Out<::std::int32_t> outIndex, const ::nn::mii::CharInfo& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetIndex, (outIndex, info));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterfaceVersion, (::std::int32_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInterfaceVersion, (version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Convert, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, const ::nn::mii::Ver3StoreData& ver3StoreData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Convert, (outInfo, ver3StoreData));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::mii::detail::IDatabaseService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::mii::detail::IDatabaseService))

    // nn::Result IsUpdated(nn::sf::Out<bool> outIsUpdated, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsUpdated)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFlags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sourceFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsUpdated, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsUpdated))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsUpdated), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsUpdated)

    // nn::Result IsFullDatabase(nn::sf::Out<bool> outIsFullDatabase) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsFullDatabase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsFullDatabase, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsFullDatabase))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsFullDatabase)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsFullDatabase)

    // nn::Result GetCount(nn::sf::Out<std::int32_t> outCount, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFlags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sourceFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCount)

    // nn::Result Get(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::CharInfoElement>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Get)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outElements, 0, (const ::nn::sf::OutArray<::nn::mii::CharInfoElement>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outElements))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFlags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sourceFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outElements), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Get)

    // nn::Result Get1(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::CharInfo>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Get1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outElements, 0, (const ::nn::sf::OutArray<::nn::mii::CharInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outElements))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFlags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sourceFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outElements), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Get1)

    // nn::Result UpdateLatest(nn::sf::Out<nn::mii::CharInfo> outInfo, const nn::mii::CharInfo& info, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateLatest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(info, (::nn::mii::CharInfo), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFlags, (::std::int32_t), 88)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (info, sourceFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(92)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outInfo, (::nn::mii::CharInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateLatest)

    // nn::Result BuildRandom(nn::sf::Out<nn::mii::CharInfo> outInfo, std::int32_t age, std::int32_t gender, std::int32_t race) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BuildRandom)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(age, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(gender, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(race, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (age, gender, race))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outInfo, (::nn::mii::CharInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(age), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(gender), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(race)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BuildRandom)

    // nn::Result BuildDefault(nn::sf::Out<nn::mii::CharInfo> outInfo, std::int32_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BuildDefault)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outInfo, (::nn::mii::CharInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BuildDefault)

    // nn::Result Get2(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::StoreDataElement>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Get2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outElements, 0, (const ::nn::sf::OutArray<::nn::mii::StoreDataElement>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outElements))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFlags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sourceFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outElements), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Get2)

    // nn::Result Get3(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::StoreData>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Get3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outElements, 0, (const ::nn::sf::OutArray<::nn::mii::StoreData>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outElements))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFlags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sourceFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outElements), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Get3)

    // nn::Result UpdateLatest1(nn::sf::Out<nn::mii::StoreData> outStoreData, const nn::mii::StoreData& storeData, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateLatest1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storeData, (::nn::mii::StoreData), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFlags, (::std::int32_t), 68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storeData, sourceFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStoreData, (::nn::mii::StoreData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outStoreData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(68)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStoreData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storeData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateLatest1)

    // nn::Result FindIndex(nn::sf::Out<std::int32_t> outIndex, const nn::mii::CreateId& id, bool enabledSpecialMii) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FindIndex)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::mii::CreateId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enabledSpecialMii, (bool), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, enabledSpecialMii))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(17)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIndex, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enabledSpecialMii)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FindIndex)

    // nn::Result Move(std::int32_t newIndex, const nn::mii::CreateId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Move)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::mii::CreateId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(newIndex, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, newIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Move)

    // nn::Result AddOrReplace(const nn::mii::StoreData& storeData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddOrReplace)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storeData, (::nn::mii::StoreData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storeData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(68)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storeData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddOrReplace)

    // nn::Result Delete(const nn::mii::CreateId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Delete)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::mii::CreateId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Delete)

    // nn::Result DestroyFile() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyFile)

    // nn::Result DeleteFile() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteFile)

    // nn::Result Format() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Format)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Format)

    // nn::Result Import(const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Import)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Import)

    // nn::Result Export(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Export)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Export)

    // nn::Result IsBrokenDatabaseWithClearFlag(nn::sf::Out<bool> outIsBrokenDatabase) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsBrokenDatabaseWithClearFlag)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsBrokenDatabase, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsBrokenDatabase))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsBrokenDatabase)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsBrokenDatabaseWithClearFlag)

    // nn::Result GetIndex(nn::sf::Out<std::int32_t> outIndex, const nn::mii::CharInfo& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIndex)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(info, (::nn::mii::CharInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (info))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIndex, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIndex)

    // nn::Result SetInterfaceVersion(std::int32_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInterfaceVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (version))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInterfaceVersion)

    // nn::Result Convert(nn::sf::Out<nn::mii::CharInfo> outInfo, const nn::mii::Ver3StoreData& ver3StoreData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Convert)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ver3StoreData, (::nn::mii::Ver3StoreData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (ver3StoreData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(96)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outInfo, (::nn::mii::CharInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ver3StoreData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Convert)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::mii::CharInfoElement), 92, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::mii::CharInfo), 88, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::mii::StoreDataElement), 72, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::mii::StoreData), 68, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::mii::CreateId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::mii::Ver3StoreData), 96, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::mii::detail::IDatabaseService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::mii::detail::IDatabaseService))

    // nn::Result IsUpdated(nn::sf::Out<bool> outIsUpdated, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUpdated, (::nn::sf::Out<bool> outIsUpdated, ::std::int32_t sourceFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsUpdated)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsUpdated)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsUpdated)
    }

    // nn::Result IsFullDatabase(nn::sf::Out<bool> outIsFullDatabase) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsFullDatabase, (::nn::sf::Out<bool> outIsFullDatabase))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsFullDatabase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsFullDatabase)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsFullDatabase)
    }

    // nn::Result GetCount(nn::sf::Out<std::int32_t> outCount, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCount, (::nn::sf::Out<::std::int32_t> outCount, ::std::int32_t sourceFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCount)
    }

    // nn::Result Get(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::CharInfoElement>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::CharInfoElement>& outElements, ::std::int32_t sourceFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Get)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outElements)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Get)
    }

    // nn::Result Get1(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::CharInfo>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get1, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::CharInfo>& outElements, ::std::int32_t sourceFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Get1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outElements)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Get1)
    }

    // nn::Result UpdateLatest(nn::sf::Out<nn::mii::CharInfo> outInfo, const nn::mii::CharInfo& info, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateLatest, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, const ::nn::mii::CharInfo& info, ::std::int32_t sourceFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateLatest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateLatest)
    }

    // nn::Result BuildRandom(nn::sf::Out<nn::mii::CharInfo> outInfo, std::int32_t age, std::int32_t gender, std::int32_t race) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BuildRandom, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, ::std::int32_t age, ::std::int32_t gender, ::std::int32_t race))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BuildRandom)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(age)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(gender)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(race)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BuildRandom)
    }

    // nn::Result BuildDefault(nn::sf::Out<nn::mii::CharInfo> outInfo, std::int32_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BuildDefault, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, ::std::int32_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BuildDefault)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BuildDefault)
    }

    // nn::Result Get2(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::StoreDataElement>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get2, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::StoreDataElement>& outElements, ::std::int32_t sourceFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Get2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outElements)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Get2)
    }

    // nn::Result Get3(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::mii::StoreData>& outElements, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get3, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::mii::StoreData>& outElements, ::std::int32_t sourceFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Get3)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outElements)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Get3)
    }

    // nn::Result UpdateLatest1(nn::sf::Out<nn::mii::StoreData> outStoreData, const nn::mii::StoreData& storeData, std::int32_t sourceFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateLatest1, (::nn::sf::Out<::nn::mii::StoreData> outStoreData, const ::nn::mii::StoreData& storeData, ::std::int32_t sourceFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateLatest1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStoreData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storeData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateLatest1)
    }

    // nn::Result FindIndex(nn::sf::Out<std::int32_t> outIndex, const nn::mii::CreateId& id, bool enabledSpecialMii) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindIndex, (::nn::sf::Out<::std::int32_t> outIndex, const ::nn::mii::CreateId& id, bool enabledSpecialMii))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FindIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enabledSpecialMii)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FindIndex)
    }

    // nn::Result Move(std::int32_t newIndex, const nn::mii::CreateId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Move, (::std::int32_t newIndex, const ::nn::mii::CreateId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Move)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Move)
    }

    // nn::Result AddOrReplace(const nn::mii::StoreData& storeData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddOrReplace, (const ::nn::mii::StoreData& storeData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddOrReplace)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storeData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddOrReplace)
    }

    // nn::Result Delete(const nn::mii::CreateId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Delete, (const ::nn::mii::CreateId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Delete)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Delete)
    }

    // nn::Result DestroyFile() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroyFile)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyFile)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyFile)
    }

    // nn::Result DeleteFile() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteFile)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteFile)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteFile)
    }

    // nn::Result Format() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Format)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Format)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Format)
    }

    // nn::Result Import(const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Import, (const ::nn::sf::InBuffer& inBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Import)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Import)
    }

    // nn::Result Export(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Export, (const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Export)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Export)
    }

    // nn::Result IsBrokenDatabaseWithClearFlag(nn::sf::Out<bool> outIsBrokenDatabase) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsBrokenDatabaseWithClearFlag, (::nn::sf::Out<bool> outIsBrokenDatabase))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsBrokenDatabaseWithClearFlag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsBrokenDatabase)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsBrokenDatabaseWithClearFlag)
    }

    // nn::Result GetIndex(nn::sf::Out<std::int32_t> outIndex, const nn::mii::CharInfo& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIndex, (::nn::sf::Out<::std::int32_t> outIndex, const ::nn::mii::CharInfo& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIndex)
    }

    // nn::Result SetInterfaceVersion(std::int32_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInterfaceVersion, (::std::int32_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInterfaceVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInterfaceVersion)
    }

    // nn::Result Convert(nn::sf::Out<nn::mii::CharInfo> outInfo, const nn::mii::Ver3StoreData& ver3StoreData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Convert, (::nn::sf::Out<::nn::mii::CharInfo> outInfo, const ::nn::mii::Ver3StoreData& ver3StoreData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Convert)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ver3StoreData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Convert)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::mii::detail::IDatabaseService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::mii::detail::IDatabaseService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsUpdated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsUpdated)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsUpdated),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsFullDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsFullDatabase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsFullDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Get)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outElements)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Get)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outElements),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Get1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outElements)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Get1)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outElements),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateLatest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateLatest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(info),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BuildRandom)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BuildRandom)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(age),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(gender),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(race)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BuildDefault)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BuildDefault)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Get2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outElements)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Get2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outElements),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Get3)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outElements)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Get3)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outElements),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateLatest1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateLatest1)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStoreData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storeData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FindIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FindIndex)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enabledSpecialMii)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Move)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Move)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(newIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddOrReplace)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddOrReplace)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storeData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Delete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Delete)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Format)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Format)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Import)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Import)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Export)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Export)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsBrokenDatabaseWithClearFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsBrokenDatabaseWithClearFlag)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsBrokenDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIndex)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInterfaceVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInterfaceVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Convert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Convert)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ver3StoreData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsUpdated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsFullDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Get)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Get1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateLatest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BuildRandom)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BuildDefault)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Get2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Get3)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateLatest1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FindIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Move)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddOrReplace)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Delete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Format)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Import)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Export)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsBrokenDatabaseWithClearFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInterfaceVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Convert)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::mii::detail::IDatabaseService))
