﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mii/detail/service/mii_ServiceCommon.h>

#include <nn/mii/mii_Common.h>
#include <nn/mii/mii_PrivateCommon.h>
#include <nn/mii/mii_ParamCommon.h>
#include <nn/mii/detail/mii_DatabaseFileManager.h>

#include <nn/sf/sf_Types.h>

#include <atomic>


namespace nn
{
namespace mii
{
namespace detail
{

class DatabaseImpl;

class DatabaseServiceInterface
{
private:
    DatabaseImpl* m_pDatabaseImpl;
    DatabaseContext m_DatabaseContext;

    const bool m_IsEditor;

    nn::Result CheckDatabaseTestModeEnabled() NN_NOEXCEPT;

public:
    DatabaseServiceInterface(
        DatabaseImpl* pDatabaseImpl,
        int specialMiiKeyCode,
        bool isEditor
    ) NN_NOEXCEPT;

    ~DatabaseServiceInterface() NN_NOEXCEPT;

    nn::Result IsUpdated(nn::sf::Out<bool>outIsUpdated, int sourceFlags) NN_NOEXCEPT;

    nn::Result IsFullDatabase(nn::sf::Out<bool>outIsFullDatabase) NN_NOEXCEPT;

    nn::Result GetCount(nn::sf::Out<int>outCount, int sourceFlags) NN_NOEXCEPT;

    nn::Result Get(nn::sf::Out<int> outCount, nn::sf::OutArray<CharInfoElement> outElements, int sourceFlags) NN_NOEXCEPT;

    nn::Result Get1(nn::sf::Out<int> outCount, nn::sf::OutArray<CharInfo> outElements, int sourceFlags) NN_NOEXCEPT;

    nn::Result UpdateLatest(nn::sf::Out<CharInfo> outInfo, const CharInfo& info, int sourceFlags) NN_NOEXCEPT;

    nn::Result BuildRandom(nn::sf::Out<CharInfo> outInfo, int age, int gender, int race) NN_NOEXCEPT;

    nn::Result BuildDefault(nn::sf::Out<CharInfo> outInfo, int index) NN_NOEXCEPT;

    nn::Result Get2(nn::sf::Out<int> outCount, nn::sf::OutArray<StoreDataElement> outElements, int sourceFlags) NN_NOEXCEPT;

    nn::Result Get3(nn::sf::Out<int> outCount, nn::sf::OutArray<StoreData> outElements, int sourceFlags) NN_NOEXCEPT;

    nn::Result UpdateLatest1(nn::sf::Out<StoreData> outStoreData, const StoreData& storeData, int sourceFlags) NN_NOEXCEPT;

    nn::Result FindIndex(nn::sf::Out<int>outIndex, const CreateId& id, bool enabledSpecialMii) NN_NOEXCEPT;

    nn::Result Move(int newIndex, const CreateId& id) NN_NOEXCEPT;

    nn::Result AddOrReplace(const StoreData& storeData) NN_NOEXCEPT;

    nn::Result Delete(const CreateId& id) NN_NOEXCEPT;

    nn::Result DestroyFile() NN_NOEXCEPT;

    nn::Result DeleteFile() NN_NOEXCEPT;

    nn::Result Format() NN_NOEXCEPT;

    nn::Result Import(const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;

    nn::Result Export(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;

    nn::Result IsBrokenDatabaseWithClearFlag(nn::sf::Out<bool> outIsBrokenDatabase) NN_NOEXCEPT;

    nn::Result GetIndex(nn::sf::Out<int> outIndex, const CharInfo& info) const NN_NOEXCEPT;

    nn::Result SetInterfaceVersion(int version) NN_NOEXCEPT;

    nn::Result Convert(nn::sf::Out<CharInfo> outInfo, const Ver3StoreData& ver3StoreData) NN_NOEXCEPT;
};

}
}
}
