﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの写像の係数の変更に関する API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/lbl/lbl_Type.h>


namespace nn {
namespace lbl {

/**
 * @brief 現在の輝度レベルからバックライト出力への写像の係数を設定します。
 * @deprecated この関数は廃止されました。呼び出しても効果はありません。将来のバージョンで削除予定です。
 */
NN_DEPRECATED void SetCurrentBrightnessMapping(const MappingCoefficient& brightnessMapping) NN_NOEXCEPT;

/**
 * @brief 輝度レベルからバックライト出力への写像の係数を取得します。
 * @deprecated この関数は廃止されました。呼び出しても pBrightnessMapping に有効な値は入りません。将来のバージョンで削除予定です。
 */
NN_DEPRECATED void GetCurrentBrightnessMapping(MappingCoefficient* pBrightnessMapping) NN_NOEXCEPT;

/**
 * @brief 現在の明るさセンサーの値から輝度レベルへの写像の係数を設定します。
 * @deprecated この関数は廃止されました。呼び出しても効果はありません。将来のバージョンで削除予定です。
 */
NN_DEPRECATED void SetCurrentAmbientLightSensorMapping(const MappingCoefficient& sensorMapping) NN_NOEXCEPT;

/**
 * @brief 現在の明るさセンサーの値から輝度レベルへの写像の係数を取得します。
 * @deprecated この関数は廃止されました。呼び出しても pSensorMapping に有効な値は入りません。将来のバージョンで削除予定です。
 */
NN_DEPRECATED void GetCurrentAmbientLightSensorMapping(MappingCoefficient* pSensorMapping) NN_NOEXCEPT;

} // lbl
} // nn


