﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの VR モード制御に関する API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace lbl {
namespace impl {

/**
 * @brief VR モードを有効にします。
 *
 * @pre         初期化されている必要があります。
 * @post        VR モードが有効になります。
 * @details     VR モードを有効にします。 VR モード中は、 VR モード向けの設定値に基づく輝度制御が行われます。
 */
void EnableVrMode() NN_NOEXCEPT;

/**
 * @brief VR モードを無効にします。
 *
 * @pre         初期化されている必要があります。
 * @post        VR モードが無効になります。
 * @details     VR モードを無効にします。
 */
void DisableVrMode() NN_NOEXCEPT;

/**
 * @brief VR モードの有効/無効の状態を取得します。
 *
 * @return      VR モードの有効/無効の状態を返します(true: 有効, false: 無効)。
 * @pre         初期化されている必要があります。
 * @details     VR モードの有効/無効の状態を取得します。
 */
bool IsVrModeEnabled() NN_NOEXCEPT;

} // impl
} // lbl
} // nn
