﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの写像の係数の変更に関する API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/lbl/lbl_Type.h>

namespace nn {
namespace lbl {
namespace impl {

/**
 * @brief 現在の輝度レベルからバックライト出力への写像の係数を設定します。
 *
 * @param[in]   brightnessMapping   設定する写像となる関数の係数
 * @pre         初期化されている必要があります。
 * @post        @a brightnessMapping が現在の写像の係数となります。
 * @details     輝度レベルからバックライト出力への写像の係数を指定します。
 *              写像は2次関数です。
 */
void SetCurrentBrightnessMapping(const MappingCoefficient& brightnessMapping) NN_NOEXCEPT;

/**
 * @brief 輝度レベルからバックライト出力への写像の係数を取得します。
 *
 * @param[out]  pBrightnessMapping  写像として使用されている関数の係数
 * @pre         初期化されている必要があります。
 *              @a pBrightnessMapping != @a nullptr である必要があります。
 * @post        @a pBrightnessMapping の値に現在使用している写像の係数が格納されます。
 * @details     輝度レベルからバックライト出力への写像の係数を取得します。
 *              写像は2次関数です。
 */
void GetCurrentBrightnessMapping(MappingCoefficient* pBrightnessMapping) NN_NOEXCEPT;

} // impl
} // lbl
} // nn


