﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/lbl/lbl_Type.h>
#include <nn/nn_TimeSpan.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace lbl { namespace detail { // NOLINT(whitespace/braces)

class ILblController;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ILblController, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ILblController)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(SaveCurrentSetting)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(LoadCurrentSetting)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessSetting, (float brightnessSetting))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetCurrentBrightnessSetting, (float))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(ApplyCurrentBrightnessSettingToBacklight)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetBrightnessSettingAppliedToBacklight, (float))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SwitchBacklightOn, (::nn::TimeSpan fadeInTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SwitchBacklightOff, (::nn::TimeSpan fadeOutTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetBacklightSwitchStatus, (::std::int32_t))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(EnableDimming)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(DisableDimming)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(IsDimmingEnabled, (bool))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(EnableAutoBrightnessControl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(DisableAutoBrightnessControl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(IsAutoBrightnessControlEnabled, (bool))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SetAmbientLightSensorValue, (float sensorValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetAmbientLightSensorValue, (float), (::nn::sf::Out<bool> pOutOverflowAlert))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SetBrightnessReflectionDelayLevel, (::std::int32_t direction, float delayLevel))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(GetBrightnessReflectionDelayLevel, (float), (::std::int32_t direction))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessMapping, (const ::nn::lbl::MappingCoefficient& brightnessMapping))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetCurrentBrightnessMapping, (::nn::sf::Out<::nn::lbl::MappingCoefficient> brightnessMapping))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentAmbientLightSensorMapping, (const ::nn::lbl::MappingCoefficient& sensorMapping))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetCurrentAmbientLightSensorMapping, (::nn::sf::Out<::nn::lbl::MappingCoefficient> sensorMapping))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(IsAmbientLightSensorAvailable, (bool))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessSettingForVrMode, (float brightnessSetting))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetCurrentBrightnessSettingForVrMode, (float))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(EnableVrMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(DisableVrMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(IsVrModeEnabled, (bool))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ILblController)

        void SaveCurrentSetting() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(SaveCurrentSetting);
        }

        void LoadCurrentSetting() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(LoadCurrentSetting);
        }

        void SetCurrentBrightnessSetting(float brightnessSetting) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SetCurrentBrightnessSetting, (brightnessSetting));
        }

        float GetCurrentBrightnessSetting() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetCurrentBrightnessSetting, (float));
        }

        void ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(ApplyCurrentBrightnessSettingToBacklight);
        }

        float GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetBrightnessSettingAppliedToBacklight, (float));
        }

        void SwitchBacklightOn(::nn::TimeSpan fadeInTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SwitchBacklightOn, (fadeInTime));
        }

        void SwitchBacklightOff(::nn::TimeSpan fadeOutTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SwitchBacklightOff, (fadeOutTime));
        }

        ::std::int32_t GetBacklightSwitchStatus() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetBacklightSwitchStatus, (::std::int32_t));
        }

        void EnableDimming() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(EnableDimming);
        }

        void DisableDimming() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(DisableDimming);
        }

        bool IsDimmingEnabled() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(IsDimmingEnabled, (bool));
        }

        void EnableAutoBrightnessControl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(EnableAutoBrightnessControl);
        }

        void DisableAutoBrightnessControl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(DisableAutoBrightnessControl);
        }

        bool IsAutoBrightnessControlEnabled() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(IsAutoBrightnessControlEnabled, (bool));
        }

        void SetAmbientLightSensorValue(float sensorValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SetAmbientLightSensorValue, (sensorValue));
        }

        float GetAmbientLightSensorValue(::nn::sf::Out<bool> pOutOverflowAlert) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetAmbientLightSensorValue, (float), (pOutOverflowAlert));
        }

        void SetBrightnessReflectionDelayLevel(::std::int32_t direction, float delayLevel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SetBrightnessReflectionDelayLevel, (direction, delayLevel));
        }

        float GetBrightnessReflectionDelayLevel(::std::int32_t direction) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(GetBrightnessReflectionDelayLevel, (float), (direction));
        }

        void SetCurrentBrightnessMapping(const ::nn::lbl::MappingCoefficient& brightnessMapping) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SetCurrentBrightnessMapping, (brightnessMapping));
        }

        void GetCurrentBrightnessMapping(::nn::sf::Out<::nn::lbl::MappingCoefficient> brightnessMapping) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetCurrentBrightnessMapping, (brightnessMapping));
        }

        void SetCurrentAmbientLightSensorMapping(const ::nn::lbl::MappingCoefficient& sensorMapping) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SetCurrentAmbientLightSensorMapping, (sensorMapping));
        }

        void GetCurrentAmbientLightSensorMapping(::nn::sf::Out<::nn::lbl::MappingCoefficient> sensorMapping) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetCurrentAmbientLightSensorMapping, (sensorMapping));
        }

        bool IsAmbientLightSensorAvailable() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(IsAmbientLightSensorAvailable, (bool));
        }

        void SetCurrentBrightnessSettingForVrMode(float brightnessSetting) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SetCurrentBrightnessSettingForVrMode, (brightnessSetting));
        }

        float GetCurrentBrightnessSettingForVrMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetCurrentBrightnessSettingForVrMode, (float));
        }

        void EnableVrMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(EnableVrMode);
        }

        void DisableVrMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(DisableVrMode);
        }

        bool IsVrModeEnabled() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(IsVrModeEnabled, (bool));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ILblController
    {
    public:
        void SaveCurrentSetting() NN_NOEXCEPT;
        void LoadCurrentSetting() NN_NOEXCEPT;
        void SetCurrentBrightnessSetting(float brightnessSetting) NN_NOEXCEPT;
        float GetCurrentBrightnessSetting() NN_NOEXCEPT;
        void ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT;
        float GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT;
        void SwitchBacklightOn(nn::TimeSpan fadeInTime) NN_NOEXCEPT;
        void SwitchBacklightOff(nn::TimeSpan fadeOutTime) NN_NOEXCEPT;
        std::int32_t GetBacklightSwitchStatus() NN_NOEXCEPT;
        void EnableDimming() NN_NOEXCEPT;
        void DisableDimming() NN_NOEXCEPT;
        bool IsDimmingEnabled() NN_NOEXCEPT;
        void EnableAutoBrightnessControl() NN_NOEXCEPT;
        void DisableAutoBrightnessControl() NN_NOEXCEPT;
        bool IsAutoBrightnessControlEnabled() NN_NOEXCEPT;
        void SetAmbientLightSensorValue(float sensorValue) NN_NOEXCEPT;
        float GetAmbientLightSensorValue(nn::sf::Out<bool> pOutOverflowAlert) NN_NOEXCEPT;
        void SetBrightnessReflectionDelayLevel(std::int32_t direction, float delayLevel) NN_NOEXCEPT;
        float GetBrightnessReflectionDelayLevel(std::int32_t direction) NN_NOEXCEPT;
        void SetCurrentBrightnessMapping(const nn::lbl::MappingCoefficient& brightnessMapping) NN_NOEXCEPT;
        void GetCurrentBrightnessMapping(nn::sf::Out<nn::lbl::MappingCoefficient> brightnessMapping) NN_NOEXCEPT;
        void SetCurrentAmbientLightSensorMapping(const nn::lbl::MappingCoefficient& sensorMapping) NN_NOEXCEPT;
        void GetCurrentAmbientLightSensorMapping(nn::sf::Out<nn::lbl::MappingCoefficient> sensorMapping) NN_NOEXCEPT;
        bool IsAmbientLightSensorAvailable() NN_NOEXCEPT;
        void SetCurrentBrightnessSettingForVrMode(float brightnessSetting) NN_NOEXCEPT;
        float GetCurrentBrightnessSettingForVrMode() NN_NOEXCEPT;
        void EnableVrMode() NN_NOEXCEPT;
        void DisableVrMode() NN_NOEXCEPT;
        bool IsVrModeEnabled() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    void SaveCurrentSetting() NN_NOEXCEPT;
    void LoadCurrentSetting() NN_NOEXCEPT;
    void SetCurrentBrightnessSetting(float brightnessSetting) NN_NOEXCEPT;
    float GetCurrentBrightnessSetting() NN_NOEXCEPT;
    void ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT;
    float GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT;
    void SwitchBacklightOn(nn::TimeSpan fadeInTime) NN_NOEXCEPT;
    void SwitchBacklightOff(nn::TimeSpan fadeOutTime) NN_NOEXCEPT;
    std::int32_t GetBacklightSwitchStatus() NN_NOEXCEPT;
    void EnableDimming() NN_NOEXCEPT;
    void DisableDimming() NN_NOEXCEPT;
    bool IsDimmingEnabled() NN_NOEXCEPT;
    void EnableAutoBrightnessControl() NN_NOEXCEPT;
    void DisableAutoBrightnessControl() NN_NOEXCEPT;
    bool IsAutoBrightnessControlEnabled() NN_NOEXCEPT;
    void SetAmbientLightSensorValue(float sensorValue) NN_NOEXCEPT;
    float GetAmbientLightSensorValue(nn::sf::Out<bool> pOutOverflowAlert) NN_NOEXCEPT;
    void SetBrightnessReflectionDelayLevel(std::int32_t direction, float delayLevel) NN_NOEXCEPT;
    float GetBrightnessReflectionDelayLevel(std::int32_t direction) NN_NOEXCEPT;
    void SetCurrentBrightnessMapping(const nn::lbl::MappingCoefficient& brightnessMapping) NN_NOEXCEPT;
    void GetCurrentBrightnessMapping(nn::sf::Out<nn::lbl::MappingCoefficient> brightnessMapping) NN_NOEXCEPT;
    void SetCurrentAmbientLightSensorMapping(const nn::lbl::MappingCoefficient& sensorMapping) NN_NOEXCEPT;
    void GetCurrentAmbientLightSensorMapping(nn::sf::Out<nn::lbl::MappingCoefficient> sensorMapping) NN_NOEXCEPT;
    bool IsAmbientLightSensorAvailable() NN_NOEXCEPT;
    void SetCurrentBrightnessSettingForVrMode(float brightnessSetting) NN_NOEXCEPT;
    float GetCurrentBrightnessSettingForVrMode() NN_NOEXCEPT;
    void EnableVrMode() NN_NOEXCEPT;
    void DisableVrMode() NN_NOEXCEPT;
    bool IsVrModeEnabled() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::lbl::detail::ILblController))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(SaveCurrentSetting)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(SaveCurrentSetting);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(LoadCurrentSetting)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(LoadCurrentSetting);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessSetting, (float brightnessSetting))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SetCurrentBrightnessSetting, (brightnessSetting));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetCurrentBrightnessSetting, (float))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetCurrentBrightnessSetting, (float));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(ApplyCurrentBrightnessSettingToBacklight)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(ApplyCurrentBrightnessSettingToBacklight);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetBrightnessSettingAppliedToBacklight, (float))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetBrightnessSettingAppliedToBacklight, (float));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SwitchBacklightOn, (::nn::TimeSpan fadeInTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SwitchBacklightOn, (fadeInTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SwitchBacklightOff, (::nn::TimeSpan fadeOutTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SwitchBacklightOff, (fadeOutTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetBacklightSwitchStatus, (::std::int32_t))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetBacklightSwitchStatus, (::std::int32_t));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableDimming)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(EnableDimming);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableDimming)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(DisableDimming);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsDimmingEnabled, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(IsDimmingEnabled, (bool));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableAutoBrightnessControl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(EnableAutoBrightnessControl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableAutoBrightnessControl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(DisableAutoBrightnessControl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsAutoBrightnessControlEnabled, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(IsAutoBrightnessControlEnabled, (bool));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetAmbientLightSensorValue, (float sensorValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SetAmbientLightSensorValue, (sensorValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetAmbientLightSensorValue, (float), (::nn::sf::Out<bool> pOutOverflowAlert))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetAmbientLightSensorValue, (float), (pOutOverflowAlert));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetBrightnessReflectionDelayLevel, (::std::int32_t direction, float delayLevel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SetBrightnessReflectionDelayLevel, (direction, delayLevel));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBrightnessReflectionDelayLevel, (float), (::std::int32_t direction))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(GetBrightnessReflectionDelayLevel, (float), (direction));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessMapping, (const ::nn::lbl::MappingCoefficient& brightnessMapping))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SetCurrentBrightnessMapping, (brightnessMapping));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetCurrentBrightnessMapping, (::nn::sf::Out<::nn::lbl::MappingCoefficient> brightnessMapping))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetCurrentBrightnessMapping, (brightnessMapping));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentAmbientLightSensorMapping, (const ::nn::lbl::MappingCoefficient& sensorMapping))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SetCurrentAmbientLightSensorMapping, (sensorMapping));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetCurrentAmbientLightSensorMapping, (::nn::sf::Out<::nn::lbl::MappingCoefficient> sensorMapping))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetCurrentAmbientLightSensorMapping, (sensorMapping));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsAmbientLightSensorAvailable, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(IsAmbientLightSensorAvailable, (bool));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessSettingForVrMode, (float brightnessSetting))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SetCurrentBrightnessSettingForVrMode, (brightnessSetting));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetCurrentBrightnessSettingForVrMode, (float))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetCurrentBrightnessSettingForVrMode, (float));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableVrMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(EnableVrMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableVrMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(DisableVrMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsVrModeEnabled, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(IsVrModeEnabled, (bool));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::lbl::detail::ILblController>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::lbl::detail::ILblController))

    // void SaveCurrentSetting() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveCurrentSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveCurrentSetting)

    // void LoadCurrentSetting() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadCurrentSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadCurrentSetting)

    // void SetCurrentBrightnessSetting(float brightnessSetting) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCurrentBrightnessSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(brightnessSetting, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (brightnessSetting))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(brightnessSetting)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCurrentBrightnessSetting)

    // float GetCurrentBrightnessSetting() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentBrightnessSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentBrightnessSetting)

    // void ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ApplyCurrentBrightnessSettingToBacklight)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ApplyCurrentBrightnessSettingToBacklight)

    // float GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBrightnessSettingAppliedToBacklight)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBrightnessSettingAppliedToBacklight)

    // void SwitchBacklightOn(nn::TimeSpan fadeInTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SwitchBacklightOn)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fadeInTime, (::nn::TimeSpan), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fadeInTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fadeInTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SwitchBacklightOn)

    // void SwitchBacklightOff(nn::TimeSpan fadeOutTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SwitchBacklightOff)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fadeOutTime, (::nn::TimeSpan), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fadeOutTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fadeOutTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SwitchBacklightOff)

    // std::int32_t GetBacklightSwitchStatus() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBacklightSwitchStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBacklightSwitchStatus)

    // void EnableDimming() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableDimming)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableDimming)

    // void DisableDimming() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableDimming)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableDimming)

    // bool IsDimmingEnabled() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsDimmingEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsDimmingEnabled)

    // void EnableAutoBrightnessControl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableAutoBrightnessControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableAutoBrightnessControl)

    // void DisableAutoBrightnessControl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableAutoBrightnessControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableAutoBrightnessControl)

    // bool IsAutoBrightnessControlEnabled() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAutoBrightnessControlEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAutoBrightnessControlEnabled)

    // void SetAmbientLightSensorValue(float sensorValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAmbientLightSensorValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sensorValue, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sensorValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sensorValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAmbientLightSensorValue)

    // float GetAmbientLightSensorValue(nn::sf::Out<bool> pOutOverflowAlert) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAmbientLightSensorValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutOverflowAlert, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (float), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutOverflowAlert, NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutOverflowAlert)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAmbientLightSensorValue)

    // void SetBrightnessReflectionDelayLevel(std::int32_t direction, float delayLevel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetBrightnessReflectionDelayLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(direction, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(delayLevel, (float), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (direction, delayLevel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(direction), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(delayLevel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetBrightnessReflectionDelayLevel)

    // float GetBrightnessReflectionDelayLevel(std::int32_t direction) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBrightnessReflectionDelayLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(direction, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (direction))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(direction)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBrightnessReflectionDelayLevel)

    // void SetCurrentBrightnessMapping(const nn::lbl::MappingCoefficient& brightnessMapping) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCurrentBrightnessMapping)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(brightnessMapping, (::nn::lbl::MappingCoefficient), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (brightnessMapping))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(brightnessMapping)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCurrentBrightnessMapping)

    // void GetCurrentBrightnessMapping(nn::sf::Out<nn::lbl::MappingCoefficient> brightnessMapping) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentBrightnessMapping)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(brightnessMapping, (::nn::lbl::MappingCoefficient), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (brightnessMapping))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(brightnessMapping)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentBrightnessMapping)

    // void SetCurrentAmbientLightSensorMapping(const nn::lbl::MappingCoefficient& sensorMapping) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCurrentAmbientLightSensorMapping)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sensorMapping, (::nn::lbl::MappingCoefficient), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sensorMapping))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sensorMapping)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCurrentAmbientLightSensorMapping)

    // void GetCurrentAmbientLightSensorMapping(nn::sf::Out<nn::lbl::MappingCoefficient> sensorMapping) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentAmbientLightSensorMapping)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(sensorMapping, (::nn::lbl::MappingCoefficient), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (sensorMapping))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sensorMapping)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentAmbientLightSensorMapping)

    // bool IsAmbientLightSensorAvailable() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAmbientLightSensorAvailable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAmbientLightSensorAvailable)

    // void SetCurrentBrightnessSettingForVrMode(float brightnessSetting) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCurrentBrightnessSettingForVrMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(brightnessSetting, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (brightnessSetting))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(brightnessSetting)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCurrentBrightnessSettingForVrMode)

    // float GetCurrentBrightnessSettingForVrMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentBrightnessSettingForVrMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentBrightnessSettingForVrMode)

    // void EnableVrMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableVrMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableVrMode)

    // void DisableVrMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableVrMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableVrMode)

    // bool IsVrModeEnabled() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsVrModeEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsVrModeEnabled)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpan), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::lbl::MappingCoefficient), 12, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::lbl::detail::ILblController, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::lbl::detail::ILblController))

    // void SaveCurrentSetting() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(SaveCurrentSetting)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveCurrentSetting)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveCurrentSetting)
    }

    // void LoadCurrentSetting() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(LoadCurrentSetting)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadCurrentSetting)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadCurrentSetting)
    }

    // void SetCurrentBrightnessSetting(float brightnessSetting) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessSetting, (float brightnessSetting))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCurrentBrightnessSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(brightnessSetting)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCurrentBrightnessSetting)
    }

    // float GetCurrentBrightnessSetting() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetCurrentBrightnessSetting, (float))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentBrightnessSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentBrightnessSetting)
    }

    // void ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(ApplyCurrentBrightnessSettingToBacklight)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ApplyCurrentBrightnessSettingToBacklight)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ApplyCurrentBrightnessSettingToBacklight)
    }

    // float GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetBrightnessSettingAppliedToBacklight, (float))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBrightnessSettingAppliedToBacklight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBrightnessSettingAppliedToBacklight)
    }

    // void SwitchBacklightOn(nn::TimeSpan fadeInTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SwitchBacklightOn, (::nn::TimeSpan fadeInTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SwitchBacklightOn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fadeInTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SwitchBacklightOn)
    }

    // void SwitchBacklightOff(nn::TimeSpan fadeOutTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SwitchBacklightOff, (::nn::TimeSpan fadeOutTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SwitchBacklightOff)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fadeOutTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SwitchBacklightOff)
    }

    // std::int32_t GetBacklightSwitchStatus() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetBacklightSwitchStatus, (::std::int32_t))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBacklightSwitchStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBacklightSwitchStatus)
    }

    // void EnableDimming() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableDimming)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableDimming)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableDimming)
    }

    // void DisableDimming() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableDimming)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableDimming)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableDimming)
    }

    // bool IsDimmingEnabled() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsDimmingEnabled, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsDimmingEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsDimmingEnabled)
    }

    // void EnableAutoBrightnessControl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableAutoBrightnessControl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableAutoBrightnessControl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableAutoBrightnessControl)
    }

    // void DisableAutoBrightnessControl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableAutoBrightnessControl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableAutoBrightnessControl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableAutoBrightnessControl)
    }

    // bool IsAutoBrightnessControlEnabled() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsAutoBrightnessControlEnabled, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAutoBrightnessControlEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAutoBrightnessControlEnabled)
    }

    // void SetAmbientLightSensorValue(float sensorValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetAmbientLightSensorValue, (float sensorValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAmbientLightSensorValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sensorValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAmbientLightSensorValue)
    }

    // float GetAmbientLightSensorValue(nn::sf::Out<bool> pOutOverflowAlert) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetAmbientLightSensorValue, (float), (::nn::sf::Out<bool> pOutOverflowAlert))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAmbientLightSensorValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutOverflowAlert)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAmbientLightSensorValue)
    }

    // void SetBrightnessReflectionDelayLevel(std::int32_t direction, float delayLevel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetBrightnessReflectionDelayLevel, (::std::int32_t direction, float delayLevel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetBrightnessReflectionDelayLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(direction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(delayLevel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetBrightnessReflectionDelayLevel)
    }

    // float GetBrightnessReflectionDelayLevel(std::int32_t direction) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(GetBrightnessReflectionDelayLevel, (float), (::std::int32_t direction))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBrightnessReflectionDelayLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(direction)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBrightnessReflectionDelayLevel)
    }

    // void SetCurrentBrightnessMapping(const nn::lbl::MappingCoefficient& brightnessMapping) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessMapping, (const ::nn::lbl::MappingCoefficient& brightnessMapping))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCurrentBrightnessMapping)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(brightnessMapping)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCurrentBrightnessMapping)
    }

    // void GetCurrentBrightnessMapping(nn::sf::Out<nn::lbl::MappingCoefficient> brightnessMapping) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetCurrentBrightnessMapping, (::nn::sf::Out<::nn::lbl::MappingCoefficient> brightnessMapping))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentBrightnessMapping)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(brightnessMapping)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentBrightnessMapping)
    }

    // void SetCurrentAmbientLightSensorMapping(const nn::lbl::MappingCoefficient& sensorMapping) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentAmbientLightSensorMapping, (const ::nn::lbl::MappingCoefficient& sensorMapping))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCurrentAmbientLightSensorMapping)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sensorMapping)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCurrentAmbientLightSensorMapping)
    }

    // void GetCurrentAmbientLightSensorMapping(nn::sf::Out<nn::lbl::MappingCoefficient> sensorMapping) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetCurrentAmbientLightSensorMapping, (::nn::sf::Out<::nn::lbl::MappingCoefficient> sensorMapping))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentAmbientLightSensorMapping)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sensorMapping)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentAmbientLightSensorMapping)
    }

    // bool IsAmbientLightSensorAvailable() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsAmbientLightSensorAvailable, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAmbientLightSensorAvailable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAmbientLightSensorAvailable)
    }

    // void SetCurrentBrightnessSettingForVrMode(float brightnessSetting) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetCurrentBrightnessSettingForVrMode, (float brightnessSetting))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCurrentBrightnessSettingForVrMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(brightnessSetting)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCurrentBrightnessSettingForVrMode)
    }

    // float GetCurrentBrightnessSettingForVrMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetCurrentBrightnessSettingForVrMode, (float))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentBrightnessSettingForVrMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentBrightnessSettingForVrMode)
    }

    // void EnableVrMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableVrMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableVrMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableVrMode)
    }

    // void DisableVrMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableVrMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableVrMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableVrMode)
    }

    // bool IsVrModeEnabled() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsVrModeEnabled, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsVrModeEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsVrModeEnabled)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::lbl::detail::ILblController>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::lbl::detail::ILblController))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveCurrentSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveCurrentSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadCurrentSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadCurrentSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCurrentBrightnessSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCurrentBrightnessSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(brightnessSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentBrightnessSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentBrightnessSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ApplyCurrentBrightnessSettingToBacklight)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ApplyCurrentBrightnessSettingToBacklight)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBrightnessSettingAppliedToBacklight)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBrightnessSettingAppliedToBacklight)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SwitchBacklightOn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SwitchBacklightOn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fadeInTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SwitchBacklightOff)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SwitchBacklightOff)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fadeOutTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBacklightSwitchStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBacklightSwitchStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableDimming)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableDimming)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableDimming)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableDimming)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsDimmingEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsDimmingEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableAutoBrightnessControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableAutoBrightnessControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableAutoBrightnessControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableAutoBrightnessControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAutoBrightnessControlEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAutoBrightnessControlEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAmbientLightSensorValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAmbientLightSensorValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sensorValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAmbientLightSensorValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAmbientLightSensorValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutOverflowAlert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetBrightnessReflectionDelayLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetBrightnessReflectionDelayLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(direction),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(delayLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBrightnessReflectionDelayLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBrightnessReflectionDelayLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(direction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCurrentBrightnessMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCurrentBrightnessMapping)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(brightnessMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentBrightnessMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentBrightnessMapping)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(brightnessMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCurrentAmbientLightSensorMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCurrentAmbientLightSensorMapping)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sensorMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentAmbientLightSensorMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentAmbientLightSensorMapping)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(sensorMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAmbientLightSensorAvailable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAmbientLightSensorAvailable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCurrentBrightnessSettingForVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCurrentBrightnessSettingForVrMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(brightnessSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentBrightnessSettingForVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentBrightnessSettingForVrMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsVrModeEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsVrModeEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveCurrentSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadCurrentSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCurrentBrightnessSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentBrightnessSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ApplyCurrentBrightnessSettingToBacklight)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBrightnessSettingAppliedToBacklight)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SwitchBacklightOn)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SwitchBacklightOff)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBacklightSwitchStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableDimming)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableDimming)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsDimmingEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableAutoBrightnessControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableAutoBrightnessControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAutoBrightnessControlEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAmbientLightSensorValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAmbientLightSensorValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetBrightnessReflectionDelayLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBrightnessReflectionDelayLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCurrentBrightnessMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentBrightnessMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCurrentAmbientLightSensorMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentAmbientLightSensorMapping)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAmbientLightSensorAvailable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCurrentBrightnessSettingForVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentBrightnessSettingForVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableVrMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsVrModeEnabled)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::lbl::detail::ILblController))
