﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Web 認証アプレットの起動時引数に関する非公開ヘッダ
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_Uuid.h>

#define NN_DETAIL_LA_CURRENT_NIFMTOWIFIWEBAUTH_VERSION                                0   // NOLINT(preprocessor/const)
#define NN_DETAIL_LA_NIFMTOWIFIWEBAUTH_ARGUMENTS_DATA_TYPE(NifmToWifiWebAuthVersion)  NN_MACRO_CONCATENATE(detail::NifmToWifiWebAuthArgumentsDataV, NifmToWifiWebAuthVersion)
#define NN_DETAIL_LA_CURRENT_NIFMTOWIFIWEBAUTH_ARGUMENTS_DATA_TYPE                    NN_DETAIL_LA_NIFMTOWIFIWEBAUTH_ARGUMENTS_DATA_TYPE(NN_DETAIL_LA_CURRENT_NIFMTOWIFIWEBAUTH_VERSION)


namespace nn { namespace la {

namespace detail {

struct NifmToWifiWebAuthArgumentsDataV0
{
    static const size_t ConnTestUrlSize = 256;
    static const size_t AuthUrlSize = 1024;

    char connTestUrl[ConnTestUrlSize];
    char authUrl[AuthUrlSize];
    nn::util::Uuid profileId;
    uint32_t submitId;
};

// 受け渡すパラメータを変更する場合、
//
// ・既存の構造体定義は残したまま、後ろに要素を増やした新しい構造体定義を追加する
// ・新しい構造体の型名は末尾のバージョンをインクリメントする
// ・NN_DETAIL_LA_CURRENT_NIFMTOWIFIWEBAUTH_VERSION マクロの値を新しいバージョンに合わせる
// ・NifmToWifiWebAuthArgumentsReader のコンストラクタに、追加した要素の初期化処理を追加する
// ・NifmToWifiWebAuthArgumentsReader::TryPopFromInChannel() の実装に、旧バージョンのハンドリングを追加する
//
// ことで、一時的に呼び出し元が先行して新しくなったとしても動作を壊さずに済み、
// また古いバージョンのクライアントにも対応できます。

}

}} // namespace nn::la

