﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ネット接続アプレットの起動時引数に関する非公開ヘッダ
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Uuid.h>

#define NN_DETAIL_LA_CURRENT_NIFMTONETCONNECT_VERSION                               0   // NOLINT(preprocessor/const)
#define NN_DETAIL_LA_NIFMTONETCONNECT_ARGUMENTS_DATA_TYPE(NifmToNetConnectVersion)  NN_MACRO_CONCATENATE(detail::NifmToNetConnectArgumentsDataV, NifmToNetConnectVersion)
#define NN_DETAIL_LA_CURRENT_NIFMTONETCONNECT_ARGUMENTS_DATA_TYPE                   NN_DETAIL_LA_NIFMTONETCONNECT_ARGUMENTS_DATA_TYPE(NN_DETAIL_LA_CURRENT_NIFMTONETCONNECT_VERSION)


namespace nn { namespace la {

namespace netconnect { // 互換性用の名前空間

enum BootMode
{
    BootMode_Default,     //!< デフォルトの起動モードです。本体設定以外はこれを使用してください。
    BootMode_FromSet,     //!< 本体設定専用です。
    BootMode_FromStarter, //!< 初回起動専用です。
    BootMode_FromNifm,    //!< Nifm からの起動専用です。
    BootMode_Num
};

}

namespace detail {

struct NifmToNetConnectArgumentsDataV0
{
    nn::Result networkConnectionResult;
    nn::util::Uuid networkProfileId;
};

// 受け渡すパラメータを変更する場合、
//
// ・既存の構造体定義は残したまま、後ろに要素を増やした新しい構造体定義を追加する
// ・新しい構造体の型名は末尾のバージョンをインクリメントする
// ・NN_DETAIL_LA_CURRENT_NIFMTONETCONNECT_VERSION マクロの値を新しいバージョンに合わせる
// ・NifmToNetConnectArgumentsReader のコンストラクタに、追加した要素の初期化処理を追加する
// ・NifmToNetConnectArgumentsReader::TryPopFromInChannel() の実装に、旧バージョンのハンドリングを追加する
//
// ことで、一時的に呼び出し元が先行して新しくなったとしても動作を壊さずに済み、
// また古いバージョンのクライアントにも対応できます。

}

}} // namespace nn::la

