﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   保護者認証引数に関する非公開ヘッダ
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace la { namespace auth {

#if defined (NN_BUILD_CONFIG_COMPILER_CLANG)
#pragma clang diagnostic push
#pragma clang diagnostic warning "-Wpadded"
#endif

/**
 * @internal
 *
 * @brief 保護者認証の背景モードを示す列挙子です。
 */
enum BackgroundMode : uint8_t
{
    BackgroundMode_Normal,   //!< 通常背景
    BackgroundMode_None,     //!< 背景なし
};

/**
 * @internal
 *
 * @brief 保護者認証を起動するパラメータ
 */
struct ParentalAuthenticationArg
{
    //! @brief 一時認証かどうかを指定します。
    bool isTemporary;

    //! @brief 背景モードを指定します。
    BackgroundMode backgroundMode;

    //! @brief 認証時に汎用設定利用・変更の許可が必要なシステムのシーンに入るかどうかを指定します。
    bool skipEnterRestrictedSystemSettings;

    uint8_t _padding0[ 1 ];

    /**
     * @brief   保護者認証を起動するパラメータにデフォルト値を設定します。
     *
     * @details 下記のデフォルト値が設定されます。
     *          - isTemporary                       : false
     *          - backgroundMode                    : BackgroundMode_Normal
     *          - skipEnterRestrictedSystemSettings : false
     */
    void SetDefault() NN_NOEXCEPT
    {
        this->isTemporary = false;
        this->backgroundMode = BackgroundMode_Normal;
        this->skipEnterRestrictedSystemSettings = false;
    }
};

#if defined (NN_BUILD_CONFIG_COMPILER_CLANG)
#pragma clang diagnostic pop
#endif

}}} // namespace nn::la::auth
