﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   認証アプレット起動引数に関する非公開ヘッダ
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/la/la_AuthParentalAuthenticationArg.h>

namespace nn { namespace la { namespace auth {

#if defined (NN_BUILD_CONFIG_COMPILER_CLANG)
#pragma clang diagnostic push
#pragma clang diagnostic warning "-Wpadded"
#endif

/**
 * @internal
 *
 * @brief auth(LA) の起動状態に関する引数です。
 */
struct AppletArg
{
    AppletArg() NN_NOEXCEPT
        : userMode( UserMode_Parent )
        , bootMode( BootMode_Authenticate )
        , isTemporary( false )
        , backgroundMode( BackgroundMode_Normal )
        , skipEnterRestrictedSystemSettings( false )
    {
        std::memset( _padding0, 0, sizeof( _padding0 ) );
    }

    /**
     * @brief ユーザーモードを示す列挙子です。
     */
    enum UserMode
    {
        UserMode_Parent,   //!< 保護者認証
        UserMode_Player    //!< プレイヤー認証(ローンチ非対応)
    };

    /**
     * @brief 起動モードを示す列挙子です。
     */
    enum BootMode
    {
        BootMode_Authenticate,   //!< 認証
        BootMode_Register,       //!< 登録
        BootMode_Change          //!< 変更
    };

    //! @brief ユーザーモードを指定します。
    UserMode userMode;

    //! @brief 起動モードを指定します。
    BootMode bootMode;

    //! @brief 一時認証かどうかを指定します。
    bool isTemporary;

    //! @brief 背景モードを指定します。
    BackgroundMode backgroundMode;

    //! @brief 認証時に汎用設定利用・変更の許可が必要なシステムのシーンに入るかどうかを指定します。
    bool skipEnterRestrictedSystemSettings;

    uint8_t _padding0[1];
};

#if defined (NN_BUILD_CONFIG_COMPILER_CLANG)
#pragma clang diagnostic pop
#endif

}}} // namespace nn::la::auth
