﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ライブラリアプレットからの応答の受け渡しをおこなうクラスの非公開ヘッダ
 */

#pragma once

#include <nn/la/la_AppletToNifmArguments.h>

#include <nn/applet/applet.h>


namespace nn { namespace la {

/**
 * @brief   ライブラリアプレットから NIFM への応答の受け渡しをおこなうクラスです。
 *          これを利用するアプレットは、 libnn_applet.a, libnn_la_callee.a, libnn_ae.a をリンクする必要があります。
 */
class AppletToNifmArgumentsWriter
{
private:
    NN_DETAIL_LA_CURRENT_APPLETTONIFM_ARGUMENTS_DATA_TYPE m_AppletToNifmArgumentsData;

public:
    /**
     * @brief   ライブラリアプレットからの応答を構築するコンストラクタです。
     *
     * @param[in] isConnTestSuccess   疎通確認に成功したか否か
     *
     * @details
     *  ネット接続アプレットの場合は、利用要求が受理された場合に true を、それ以外の場合に false を渡します。@n
     *  Web 認証アプレットの場合は、利用要求が受理され、その後の疎通確認に成功した場合に true を渡します。それ以外の場合は false を渡します。@n
     *  エラービューアは、本クラスを利用しません。
     */
    NN_IMPLICIT AppletToNifmArgumentsWriter(bool isConnTestSuccess) NN_NOEXCEPT;

    /**
     * @brief   デストラクタです。
     *
     * @details
     */
    ~AppletToNifmArgumentsWriter() NN_NOEXCEPT;

    /**
     * @brief   必要パラメータを一つのストレージにまとめ、出力チャンネルに push します。
     *
     * @details
     */
    void PushToOutChannel() const NN_NOEXCEPT;
};

}} // namespace nn::la

