﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ライブラリアプレットからの応答に関する非公開ヘッダ
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Uuid.h>

#define NN_DETAIL_LA_CURRENT_APPLETTONIFM_VERSION                               0   // NOLINT(preprocessor/const)
#define NN_DETAIL_LA_APPLETTONIFM_ARGUMENTS_DATA_TYPE(AppletToNifmVersion)      NN_MACRO_CONCATENATE(detail::AppletToNifmArgumentsDataV, AppletToNifmVersion)
#define NN_DETAIL_LA_CURRENT_APPLETTONIFM_ARGUMENTS_DATA_TYPE                   NN_DETAIL_LA_APPLETTONIFM_ARGUMENTS_DATA_TYPE(NN_DETAIL_LA_CURRENT_APPLETTONIFM_VERSION)


namespace nn { namespace la {

namespace detail {

struct AppletToNifmArgumentsDataV0
{
    nn::Result result;
};

// 受け渡すパラメータを変更する場合、
//
// ・既存の構造体定義は残したまま、後ろに要素を増やした新しい構造体定義を追加する
// ・新しい構造体の型名は末尾のバージョンをインクリメントする
// ・NN_DETAIL_LA_CURRENT_APPLETTONIFM_VERSION マクロの値を新しいバージョンに合わせる
// ・AppletToNifmArgumentsReader のコンストラクタに、追加した要素の初期化処理を追加する
// ・AppletToNifmArgumentsReader::TryPopFromInChannel() の実装に、旧バージョンのハンドリングを追加する
//
// ことで、一時的に呼び出し元が先行して新しくなったとしても動作を壊さずに済み、
// また古いバージョンのクライアントにも対応できます。

}

}} // namespace nn::la

