﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <type_traits>
#include <nn/jit/jit_CommonTypes.h>
#include <nn/jit/plugin/jit_Plugin.h>
#include <nn/diag/diag_LogObserver.h>

namespace nn { namespace jit { namespace plugin {

const uint32_t PluginVersion = 1;
const uint32_t DiagnosticsVersion = 1;

struct DiagnosticsParameters
{
    uintptr_t (*lookupSymbol)(const char* name);
};

struct ConfigureParameters
{
    int codeMemorySecurity;
    int workMemorySecurity;
};

}}}

#define NN_JIT_PLUGIN_FUNCTION_NAME(name) nnjitplugin##name
#define NN_JIT_PLUGIN_FUNCTION(name, ret, args) extern "C" ret NN_JIT_PLUGIN_FUNCTION_NAME(name)args
#define NN_JIT_PLUGIN_FUNCTION_POINTER_TYPE(name) ::std::decay<decltype(NN_JIT_PLUGIN_FUNCTION_NAME(name))>::type
#define NN_JIT_PLUGIN_VISIBILITY_PROTECTED __attribute__((visibility("protected")))

NN_JIT_PLUGIN_FUNCTION(Keeper, uintptr_t, ()) NN_JIT_PLUGIN_VISIBILITY_PROTECTED;

NN_JIT_PLUGIN_FUNCTION(GetVersion, uint32_t, ()) NN_JIT_PLUGIN_VISIBILITY_PROTECTED;
NN_JIT_PLUGIN_FUNCTION(ResolveBasicSymbols, void, (uintptr_t (*)(const char* name))) NN_JIT_PLUGIN_VISIBILITY_PROTECTED;
NN_JIT_PLUGIN_FUNCTION(SetupDiagnostics, void, (uint32_t version, const nn::jit::plugin::DiagnosticsParameters* p)) NN_JIT_PLUGIN_VISIBILITY_PROTECTED;
NN_JIT_PLUGIN_FUNCTION(Configure, void, (nn::jit::plugin::ConfigureParameters* p)) NN_JIT_PLUGIN_VISIBILITY_PROTECTED;
NN_JIT_PLUGIN_FUNCTION(OnPrepared, void, (const nn::jit::plugin::JitPluginEnvironment& info)) NN_JIT_PLUGIN_VISIBILITY_PROTECTED;

NN_JIT_PLUGIN_FUNCTION(GenerateCode, int, (int* pOut, nn::jit::CodeRange* pGeneratedRx, nn::jit::CodeRange* pGeneratedRo, const nn::jit::plugin::JitPluginEnvironment& environment, uint64_t tag, const void* source, size_t sourceSize, const nn::jit::CodeRange& rxBuffer, const nn::jit::CodeRange& roBuffer, const void* inData, size_t inDataSize, void* outBuffer, size_t outBufferSize)) NN_JIT_PLUGIN_VISIBILITY_PROTECTED;
NN_JIT_PLUGIN_FUNCTION(Control, int, (int* pOut, const nn::jit::plugin::JitPluginEnvironment& info, uint64_t tag, const void* inData, size_t inDataSize, void* outBuffer, size_t outBufferSize)) NN_JIT_PLUGIN_VISIBILITY_PROTECTED;
