﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os.h>
#include <nn/idle/idle_SystemTypes.h>

namespace nn { namespace idle { namespace server {

void InitializeHandlerManager() NN_NOEXCEPT;
void EnableHandlers() NN_NOEXCEPT;
void DisableHandlers() NN_NOEXCEPT;
void LoadAndApplySettings() NN_NOEXCEPT;
Result SetHandlingContext(const HandlingContext& handlingContext) NN_NOEXCEPT;
void UpdateIdleCountBaseTime(const nn::TimeSpan& newBase) NN_NOEXCEPT;
void ResetIdleTimeCount() NN_NOEXCEPT;
void UpdateHandlerStatus(nn::TimeSpan interval) NN_NOEXCEPT;
nn::os::SystemEventType* GetAutoPowerDownEvent() NN_NOEXCEPT;
bool IsAutoPowerDownOn() NN_NOEXCEPT;
bool IsDimmingOn() NN_NOEXCEPT;

}}} // namespace nn::idle::server
