﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_DeviceCode.h>

#include <nn/TargetConfigs/build_Base.h>
#include <nn/devicecode/devicecode_Predefined.i2c.h>
#include <nn/i2c/i2c_DeviceName.h>

namespace nn { namespace i2c {

const char I2cServiceName[]       = "i2c";
const char I2cPowerBusServiceName[] = "i2c:pcv";

typedef Bit8 I2cCommand;

// 対応プラットフォームが増えた場合は切り替えをここで行う
#if (defined(NN_BUILD_CONFIG_SPEC_NX))

// 論理的な通信チャネルの最大値
const int MaxDriverSessions          = 40;

inline const char* GetServiceName(nn::DeviceCode deviceCode)
{
    if ( deviceCode == NN_DEVICECODE_REGULATOR_BOARD
        || deviceCode == NN_DEVICECODE_REGULATOR_CPU
        || deviceCode == NN_DEVICECODE_REGULATOR_GPU
        || deviceCode == NN_DEVICECODE_REGULATOR_DRAM
        || deviceCode == NN_DEVICECODE_REGULATOR_CPU_GPU
        || deviceCode == NN_DEVICECODE_RTC_BOARD )
    {
        return I2cPowerBusServiceName;
    }

    return I2cServiceName;
}

inline const char* GetServiceName(nn::i2c::I2cDevice device)
{
    switch(device)
    {
    case I2cDevice_Max77620Rtc:
    case I2cDevice_Max77620Pmic:
    case I2cDevice_Max77621Cpu:
    case I2cDevice_Max77621Gpu:
    case I2cDevice_Fan53528:
    case I2cDevice_Max77812_3_1:
    case I2cDevice_Max77812_2_1_1:
        return I2cPowerBusServiceName;

    default :
        return I2cServiceName;
    }
}

inline const char* GetServiceNameForDev(int bus)
{
    switch(bus)
    {
    case 4:
        return I2cPowerBusServiceName;

    default :
        return I2cServiceName;
    }
}

#else

// 論理的な通信チャネルの最大値
const int MaxDriverSessions          = 20;

inline const char* GetServiceName(nn::DeviceCode deviceCode)
{
    NN_UNUSED(deviceCode);
    return I2cServiceName;
}

inline const char* GetServiceName(nn::i2c::I2cDevice device)
{
    NN_UNUSED(device);
    return I2cServiceName;
}

inline const char* GetServiceNameForDev(int bus)
{
    NN_UNUSED(bus);
    return I2cServiceName;
}

#endif

}}
