﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/i2c/i2c_ServiceType.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace i2c { // NOLINT(whitespace/braces)

class ISession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendOld, (const ::nn::sf::InBuffer& inData, ::std::int32_t inOption))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveOld, (const ::nn::sf::OutBuffer& outData, ::std::int32_t inOption))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExecuteCommandListOld, (const ::nn::sf::OutBuffer& receiveBuffer, const ::nn::sf::InArray<::nn::i2c::I2cCommand>& commandList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Send, (const ::nn::sf::InBuffer& inData, ::std::int32_t inOption))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (const ::nn::sf::OutBuffer& outData, ::std::int32_t inOption))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExecuteCommandList, (const ::nn::sf::OutBuffer& receiveBuffer, const ::nn::sf::InArray<::nn::i2c::I2cCommand>& commandList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRetryPolicy, (::std::int32_t maxRetryCount, ::std::int32_t retryIntervalMicroSeconds))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISession)

        ::nn::Result SendOld(const ::nn::sf::InBuffer& inData, ::std::int32_t inOption) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendOld, (inData, inOption));
        }

        ::nn::Result ReceiveOld(const ::nn::sf::OutBuffer& outData, ::std::int32_t inOption) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReceiveOld, (outData, inOption));
        }

        ::nn::Result ExecuteCommandListOld(const ::nn::sf::OutBuffer& receiveBuffer, const ::nn::sf::InArray<::nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExecuteCommandListOld, (receiveBuffer, commandList));
        }

        ::nn::Result Send(const ::nn::sf::InBuffer& inData, ::std::int32_t inOption) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Send, (inData, inOption));
        }

        ::nn::Result Receive(const ::nn::sf::OutBuffer& outData, ::std::int32_t inOption) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Receive, (outData, inOption));
        }

        ::nn::Result ExecuteCommandList(const ::nn::sf::OutBuffer& receiveBuffer, const ::nn::sf::InArray<::nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExecuteCommandList, (receiveBuffer, commandList));
        }

        ::nn::Result SetRetryPolicy(::std::int32_t maxRetryCount, ::std::int32_t retryIntervalMicroSeconds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRetryPolicy, (maxRetryCount, retryIntervalMicroSeconds));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISession
    {
    public:
        nn::Result SendOld(const nn::sf::InBuffer& inData, std::int32_t inOption) NN_NOEXCEPT;
        nn::Result ReceiveOld(const nn::sf::OutBuffer& outData, std::int32_t inOption) NN_NOEXCEPT;
        nn::Result ExecuteCommandListOld(const nn::sf::OutBuffer& receiveBuffer, const nn::sf::InArray<nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT;
        nn::Result Send(const nn::sf::InBuffer& inData, std::int32_t inOption) NN_NOEXCEPT;
        nn::Result Receive(const nn::sf::OutBuffer& outData, std::int32_t inOption) NN_NOEXCEPT;
        nn::Result ExecuteCommandList(const nn::sf::OutBuffer& receiveBuffer, const nn::sf::InArray<nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT;
        nn::Result SetRetryPolicy(std::int32_t maxRetryCount, std::int32_t retryIntervalMicroSeconds) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SendOld(const nn::sf::InBuffer& inData, std::int32_t inOption) NN_NOEXCEPT;
    nn::Result ReceiveOld(const nn::sf::OutBuffer& outData, std::int32_t inOption) NN_NOEXCEPT;
    nn::Result ExecuteCommandListOld(const nn::sf::OutBuffer& receiveBuffer, const nn::sf::InArray<nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT;
    nn::Result Send(const nn::sf::InBuffer& inData, std::int32_t inOption) NN_NOEXCEPT;
    nn::Result Receive(const nn::sf::OutBuffer& outData, std::int32_t inOption) NN_NOEXCEPT;
    nn::Result ExecuteCommandList(const nn::sf::OutBuffer& receiveBuffer, const nn::sf::InArray<nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT;
    nn::Result SetRetryPolicy(std::int32_t maxRetryCount, std::int32_t retryIntervalMicroSeconds) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::i2c::ISession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendOld, (const ::nn::sf::InBuffer& inData, ::std::int32_t inOption))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendOld, (inData, inOption));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveOld, (const ::nn::sf::OutBuffer& outData, ::std::int32_t inOption))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReceiveOld, (outData, inOption));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExecuteCommandListOld, (const ::nn::sf::OutBuffer& receiveBuffer, const ::nn::sf::InArray<::nn::i2c::I2cCommand>& commandList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExecuteCommandListOld, (receiveBuffer, commandList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (const ::nn::sf::InBuffer& inData, ::std::int32_t inOption))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Send, (inData, inOption));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (const ::nn::sf::OutBuffer& outData, ::std::int32_t inOption))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Receive, (outData, inOption));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExecuteCommandList, (const ::nn::sf::OutBuffer& receiveBuffer, const ::nn::sf::InArray<::nn::i2c::I2cCommand>& commandList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExecuteCommandList, (receiveBuffer, commandList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRetryPolicy, (::std::int32_t maxRetryCount, ::std::int32_t retryIntervalMicroSeconds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRetryPolicy, (maxRetryCount, retryIntervalMicroSeconds));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::i2c::ISession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::i2c::ISession))

    // nn::Result SendOld(const nn::sf::InBuffer& inData, std::int32_t inOption) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inOption, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (inOption))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inOption)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendOld)

    // nn::Result ReceiveOld(const nn::sf::OutBuffer& outData, std::int32_t inOption) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReceiveOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inOption, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (inOption))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inOption)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReceiveOld)

    // nn::Result ExecuteCommandListOld(const nn::sf::OutBuffer& receiveBuffer, const nn::sf::InArray<nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExecuteCommandListOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(receiveBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(commandList, 1, (const ::nn::sf::InArray<::nn::i2c::I2cCommand>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (receiveBuffer, commandList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiveBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(commandList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExecuteCommandListOld)

    // nn::Result Send(const nn::sf::InBuffer& inData, std::int32_t inOption) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Send)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inOption, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (inOption))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inOption)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Send)

    // nn::Result Receive(const nn::sf::OutBuffer& outData, std::int32_t inOption) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Receive)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inOption, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (inOption))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inOption)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Receive)

    // nn::Result ExecuteCommandList(const nn::sf::OutBuffer& receiveBuffer, const nn::sf::InArray<nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExecuteCommandList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(receiveBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(commandList, 1, (const ::nn::sf::InArray<::nn::i2c::I2cCommand>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (receiveBuffer, commandList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiveBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(commandList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExecuteCommandList)

    // nn::Result SetRetryPolicy(std::int32_t maxRetryCount, std::int32_t retryIntervalMicroSeconds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRetryPolicy)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxRetryCount, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(retryIntervalMicroSeconds, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (maxRetryCount, retryIntervalMicroSeconds))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxRetryCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(retryIntervalMicroSeconds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRetryPolicy)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::i2c::I2cCommand), 1, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::i2c::ISession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::i2c::ISession))

    // nn::Result SendOld(const nn::sf::InBuffer& inData, std::int32_t inOption) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendOld, (const ::nn::sf::InBuffer& inData, ::std::int32_t inOption))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inOption)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendOld)
    }

    // nn::Result ReceiveOld(const nn::sf::OutBuffer& outData, std::int32_t inOption) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveOld, (const ::nn::sf::OutBuffer& outData, ::std::int32_t inOption))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReceiveOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inOption)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReceiveOld)
    }

    // nn::Result ExecuteCommandListOld(const nn::sf::OutBuffer& receiveBuffer, const nn::sf::InArray<nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExecuteCommandListOld, (const ::nn::sf::OutBuffer& receiveBuffer, const ::nn::sf::InArray<::nn::i2c::I2cCommand>& commandList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExecuteCommandListOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiveBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(commandList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExecuteCommandListOld)
    }

    // nn::Result Send(const nn::sf::InBuffer& inData, std::int32_t inOption) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (const ::nn::sf::InBuffer& inData, ::std::int32_t inOption))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Send)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inOption)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Send)
    }

    // nn::Result Receive(const nn::sf::OutBuffer& outData, std::int32_t inOption) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Receive, (const ::nn::sf::OutBuffer& outData, ::std::int32_t inOption))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Receive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inOption)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Receive)
    }

    // nn::Result ExecuteCommandList(const nn::sf::OutBuffer& receiveBuffer, const nn::sf::InArray<nn::i2c::I2cCommand>& commandList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExecuteCommandList, (const ::nn::sf::OutBuffer& receiveBuffer, const ::nn::sf::InArray<::nn::i2c::I2cCommand>& commandList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExecuteCommandList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiveBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(commandList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExecuteCommandList)
    }

    // nn::Result SetRetryPolicy(std::int32_t maxRetryCount, std::int32_t retryIntervalMicroSeconds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRetryPolicy, (::std::int32_t maxRetryCount, ::std::int32_t retryIntervalMicroSeconds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRetryPolicy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxRetryCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(retryIntervalMicroSeconds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRetryPolicy)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::i2c::ISession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::i2c::ISession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReceiveOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReceiveOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExecuteCommandListOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(receiveBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(commandList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExecuteCommandListOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(receiveBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(commandList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Send)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Receive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Receive)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExecuteCommandList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(receiveBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(commandList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExecuteCommandList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(receiveBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(commandList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRetryPolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRetryPolicy)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxRetryCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(retryIntervalMicroSeconds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReceiveOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExecuteCommandListOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Receive)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExecuteCommandList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRetryPolicy)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::i2c::ISession))
