﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{
namespace i2c{

/**
* @brief デバイス識別子 I2cDevice の定義
*
* @details I2Cドライバライブラリがサポートする I2cDevice の一覧です。
*/
enum I2cDevice
{
    I2cDevice_ClassicController, //!< Debug pad
    I2cDevice_Ftm3bd56,          //!< Touch panel
    I2cDevice_Tmp451,            //!< Thermal sensor
    I2cDevice_Nct72,             //!< Thermal sensor
    I2cDevice_Alc5639,           //!< Audio codec
    I2cDevice_Max77620Rtc,       //!< Power management unit - RTC
    I2cDevice_Max77620Pmic,      //!< Power management unit - Pmic
    I2cDevice_Max77621Cpu,       //!< Power management unit - CPU
    I2cDevice_Max77621Gpu,       //!< Power management unit - GPU
    I2cDevice_Bq24193,           //!< Charger
    I2cDevice_Max17050,          //!< Fuel gauge
    I2cDevice_Bm92t30mwv,        //!< Power delivery controller
    I2cDevice_Ina226Vdd15v0Hb,   //!< Power monitor - V_VDD15V0-HB
    I2cDevice_Ina226VsysCpuDs,   //!< Power monitor - CPU
    I2cDevice_Ina226VsysGpuDs,   //!< Power monitor - GPU
    I2cDevice_Ina226VsysDdrDs,   //!< Power monitor - LPDDR4
    I2cDevice_Ina226VsysAp,      //!< Power monitor - V_SYS_AP
    I2cDevice_Ina226VsysBlDs,    //!< Power monitor - BackLight
    I2cDevice_Bh1730,            //!< Ambient light sensor
    I2cDevice_Ina226VsysCore,    //!< Power monitor - Core
    I2cDevice_Ina226Soc1V8,      //!< Power monitor - SoC 1V8
    I2cDevice_Ina226Lpddr1V8,    //!< Power monitor - LPDDR4 1V8
    I2cDevice_Ina226Reg1V32,     //!< Power monitor - REG1V32
    I2cDevice_Ina226Vdd3V3Sys,   //!< Power monitor - VDD3V3-SYS
    I2cDevice_HdmiDdc,           //!< HDMI DDC
    I2cDevice_HdmiScdc,          //!< HDMI SCDC
    I2cDevice_HdmiHdcp,          //!< HDMI HDCP
    I2cDevice_Fan53528,          //!< Fan53528
    I2cDevice_Max77812_3_1,      //!< Max77812 (3phase)
    I2cDevice_Max77812_2_1_1,    //!< Max77812 (2phase)
    I2cDevice_Ina226VddDdr0V6,   //!< Power monitor - V_VDD-DDR-0V6
};

} //i2c
} //nn
