﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/i2c/driver/detail/dt/i2c_DeviceCodeNodeParser.h>
#include <nn/i2c/driver/i2c_II2cDriver.h>

namespace nn { namespace i2c { namespace driver {

void RegisterDriver(II2cDriver* pDriver) NN_NOEXCEPT;

void RegisterDeviceCodeNodeParser(nn::i2c::driver::detail::dt::IDeviceCodeNodeParser* pParser) NN_NOEXCEPT;

nn::Result RegisterDeviceCode(nn::DeviceCode deviceCode, I2cDeviceProperty* pDevice) NN_NOEXCEPT;

}}} // nn::i2c::driver
