﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  HTTP ライブラリの Result コード。
*/

#pragma once

#include <nn/nn_ErrorResult.h>

namespace nn
{
namespace http
{

    #include "http_Result.public.h"

    using ResultCanceled = ResultCancelled;

    using ResultHttpStatus400BadRequest = ResultHttpStatusBadRequest;
    using ResultHttpStatus401Unauthorized = ResultHttpStatusUnauthorized;
    using ResultHttpStatus402PaymentRequired = ResultHttpStatusPaymentRequired;
    using ResultHttpStatus403Forbidden = ResultHttpStatusForbidden;
    using ResultHttpStatus404NotFound = ResultHttpStatusNotFound;
    using ResultHttpStatus405MethodNotAllowed = ResultHttpStatusMethodNotAllowed;
    using ResultHttpStatus406NotAcceptable = ResultHttpStatusNotAcceptable;
    using ResultHttpStatus407ProxyAuthenticationRequired = ResultHttpStatusProxyAuthenticationRequired;
    using ResultHttpStatus408RequestTimeout = ResultHttpStatusRequestTimeout;
    using ResultHttpStatus409Conflict = ResultHttpStatusConflict;
    using ResultHttpStatus410Gone = ResultHttpStatusGone;
    using ResultHttpStatus411LengthRequired = ResultHttpStatusLengthRequired;
    using ResultHttpStatus412PreconditionFailed = ResultHttpStatusPreconditionFailed;
    using ResultHttpStatus413PayloadTooLarge = ResultHttpStatusPayloadTooLarge;
    using ResultHttpStatus414UriTooLong = ResultHttpStatusUriTooLong;
    using ResultHttpStatus415UnsupportedMediaType = ResultHttpStatusUnsupportedMediaType;
    using ResultHttpStatus416RangeNotSatisfiable = ResultHttpStatusRangeNotSatisfiable;
    using ResultHttpStatus417ExpectationFailed = ResultHttpStatusExpectationFailed;
    using ResultHttpStatus418ImATeaPot = ResultHttpStatusImATeaPot;
    using ResultHttpStatus422UnprocessableEntity = ResultHttpStatusUnprocessableEntity;
    using ResultHttpStatus423Locked = ResultHttpStatusLocked;
    using ResultHttpStatus424FailedDependency = ResultHttpStatusFailedDependency;
    using ResultHttpStatus426UpgradeRequired = ResultHttpStatusUpgradeRequired;
    using ResultHttpStatus451UnavailableForLegalReasons = ResultHttpStatusUnavailableForLegalReasons;
    using ResultHttpStatus500InternalServerError = ResultHttpStatusInternalServerError;
    using ResultHttpStatus501NotImplemented = ResultHttpStatusNotImplemented;
    using ResultHttpStatus502BadGateway = ResultHttpStatusBadGateway;
    using ResultHttpStatus503ServiceUnavailable = ResultHttpStatusServiceUnavailable;
    using ResultHttpStatus504GatewayTimeout = ResultHttpStatusGatewayTimeout;
    using ResultHttpStatus505HttpVersionNotSupported = ResultHttpStatusHttpVersionNotSupported;
    using ResultHttpStatus506VariantAlsoNegoriates = ResultHttpStatusVariantAlsoNegoriates;
    using ResultHttpStatus507InsufficientStorage = ResultHttpStatusInsufficientStorage;
    using ResultHttpStatus508LoopDetected = ResultHttpStatusLoopDetected;
    using ResultHttpStatus509BandwidthLimitExceeded = ResultHttpStatusBandwidthLimitExceeded;
    using ResultHttpStatus510NotExtended = ResultHttpStatusNotExtended;
    using ResultHttpStatus511NetworkAuthenticationRequired = ResultHttpStatusNetworkAuthenticationRequired;
} // http
} // nn
