﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/nn_Result.h>
// TODO
#include <curl/curl.h>

namespace nn
{
namespace http
{

    /**
    *   @brief      メモリ確保用の関数ポインタです。
    */
    typedef void* (*AllocateFunction)(size_t);

    /**
    *   @brief      メモリ解放用の関数ポインタです。
    */
    typedef void  (*FreeFunction)(void*);

    /**
    *   @brief      メモリ再確保用の関数ポインタです。
    */
    typedef void* (*ReAllocateFunction)(void*, size_t);

    ///////////////////////////////////////////////////////////////////////////
    //! @name HTTP ライブラリの初期化・終了 API
    //! @{

    /**
     * @brief   ライブラリの初期化をおこない、機能を使用可能な状態にします。
     *
     * @return  処理の結果が返ります。
     *
     * @details
     *  ライブラリが提供する API は、個別に明示されていないかぎり、利用前にこの関数でライブラリを初期化しておく必要があります。@n
     */
    Result Initialize(AllocateFunction allocfun, FreeFunction freefun, ReAllocateFunction reallocfun);
    Result Initialize(void* p, size_t size);
    Result Initialize();

    bool IsInitialized();

    void Finalize();
    //! @}
}
}
