﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

 /**
  * @file
  * @brief   HDCP ライブラリの定数・列挙体の定義
  */

#pragma once

namespace nn {
namespace hdcp {

/**
 * @brief HDCPの認証状態。
 */
enum HdcpAuthenticationState
{
    HdcpAuthenticationState_Unauthenticated,        //!< 未認証
    HdcpAuthenticationState_Processing,             //!< 認証中
    HdcpAuthenticationState_NotPlugged,              //!< ディスプレイ未接続
    HdcpAuthenticationState_Timeout,                //!< 認証のタイムアウト
    HdcpAuthenticationState_Authenticated,          //!< 認証完了
};
/**
  @deprecated
  @brief 非対応ディスプレイの接続を示すこの定数は廃止予定です。
*/
NN_DEPRECATED const HdcpAuthenticationState HdcpAuthenticationState_UnsupportedDisplay =
HdcpAuthenticationState(HdcpAuthenticationState_Timeout + 1);

/**
 * @brief HDCPの有効/無効の設定値。
 */
enum HdcpMode
{
    HdcpMode_Disabled,  //!< HDCP無効
    HdcpMode_Enabled,   //!< HDCP有効
};

} // hdcp
} // nn
