﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include <nn/gpio/gpio_IManager.sfdl.h>
#include <nn/gpio/gpio_IPadSession.sfdl.h>

namespace nn { namespace gpio { namespace server {

// IManager 実装クラス
class ManagerImpl
    : public nn::sf::ISharedObject
{

public:

    ManagerImpl() NN_NOEXCEPT;
    ~ManagerImpl() NN_NOEXCEPT;

    // [Gen1] TODO: Deprecate
    nn::Result OpenSessionForDev(nn::sf::Out<nn::sf::SharedPointer<nn::gpio::IPadSession>> outSession, std::int32_t pad) NN_NOEXCEPT;
    nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::gpio::IPadSession>> outSession, std::int32_t pad) NN_NOEXCEPT;
    nn::Result OpenSessionForTest(nn::sf::Out<nn::sf::SharedPointer<nn::gpio::IPadSession>> outSession, std::int32_t pad) NN_NOEXCEPT;
    nn::Result IsWakeEventActive(nn::sf::Out<bool> isActive, std::int32_t name) NN_NOEXCEPT;
    nn::Result GetWakeEventActiveFlagSet(nn::sf::Out<nn::gpio::WakeBitFlag> flag) NN_NOEXCEPT; // [Gen2] NOT SUPPORTED
    nn::Result SetWakeEventActiveFlagSetForDebug(std::int32_t name, bool isEnabled) NN_NOEXCEPT;

    // [Gen2]
    nn::Result OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nn::gpio::IPadSession>> outSession, nn::detail::DeviceCodeType padName) NN_NOEXCEPT;
    nn::Result IsWakeEventActive2(nn::sf::Out<bool> isActive, nn::detail::DeviceCodeType name) NN_NOEXCEPT;
    nn::Result SetWakeEventActiveFlagSetForDebug2(nn::detail::DeviceCodeType name, bool isEnabled) NN_NOEXCEPT;

    nn::Result SetWakePinDebugMode(std::int32_t mode) NN_NOEXCEPT;

private:

    // OpenSession / OpenSessionForDev 用アロケータとして、
    // stateful な nn::sf::ExpHeapAllocator を使用する。
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    std::aligned_storage<12 * 1024>::type m_HeapBuffer;

    nn::lmem::HeapHandle m_HeapHandle;
};

}}}
