﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      gpio モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_GPIO_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_GPIO_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_GPIO_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_GPIO_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_GPIO_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_GPIO_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(gpio, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_GPIO_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Trace, 0, format, args)
#define NN_DETAIL_GPIO_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Trace, 1, format, args)
#define NN_DETAIL_GPIO_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Trace, 2, format, args)
#define NN_DETAIL_GPIO_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Trace, 3, format, args)

#define NN_DETAIL_GPIO_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Info, 0, format, args)
#define NN_DETAIL_GPIO_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Info, 1, format, args)
#define NN_DETAIL_GPIO_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Info, 2, format, args)
#define NN_DETAIL_GPIO_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Info, 3, format, args)

#define NN_DETAIL_GPIO_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Warn, 0, format, args)
#define NN_DETAIL_GPIO_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Warn, 1, format, args)
#define NN_DETAIL_GPIO_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Warn, 2, format, args)
#define NN_DETAIL_GPIO_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Warn, 3, format, args)

#define NN_DETAIL_GPIO_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Error, 0, format, args)
#define NN_DETAIL_GPIO_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Error, 1, format, args)
#define NN_DETAIL_GPIO_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Error, 2, format, args)
#define NN_DETAIL_GPIO_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Error, 3, format, args)

#define NN_DETAIL_GPIO_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Fatal, 0, format, args)
#define NN_DETAIL_GPIO_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Fatal, 1, format, args)
#define NN_DETAIL_GPIO_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Fatal, 2, format, args)
#define NN_DETAIL_GPIO_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(gpio, Fatal, 3, format, args)

#define NN_DETAIL_GPIO_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Trace, 0, text, length)
#define NN_DETAIL_GPIO_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Trace, 1, text, length)
#define NN_DETAIL_GPIO_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Trace, 2, text, length)
#define NN_DETAIL_GPIO_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Trace, 3, text, length)

#define NN_DETAIL_GPIO_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Info, 0, text, length)
#define NN_DETAIL_GPIO_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Info, 1, text, length)
#define NN_DETAIL_GPIO_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Info, 2, text, length)
#define NN_DETAIL_GPIO_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Info, 3, text, length)

#define NN_DETAIL_GPIO_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Warn, 0, text, length)
#define NN_DETAIL_GPIO_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Warn, 1, text, length)
#define NN_DETAIL_GPIO_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Warn, 2, text, length)
#define NN_DETAIL_GPIO_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Warn, 3, text, length)

#define NN_DETAIL_GPIO_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Error, 0, text, length)
#define NN_DETAIL_GPIO_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Error, 1, text, length)
#define NN_DETAIL_GPIO_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Error, 2, text, length)
#define NN_DETAIL_GPIO_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Error, 3, text, length)

#define NN_DETAIL_GPIO_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Fatal, 0, text, length)
#define NN_DETAIL_GPIO_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Fatal, 1, text, length)
#define NN_DETAIL_GPIO_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Fatal, 2, text, length)
#define NN_DETAIL_GPIO_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(gpio, Fatal, 3, text, length)
