﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  セーブデータ関連 API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/nn_ApplicationId.h>

namespace nn { namespace fs {

//! @name セーブデータ関連 API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      指定したアプリケーションのユーザーアカウントセーブデータをマウントします。
*
*   @details    指定したアプリケーション ID およびユーザーに対応するセーブデータをマウント名 name でマウントします。
*
*   @param[in]  name           マウント名
*   @param[in]  applicationId  対象のアプリケーション ID
*   @param[in]  user           対象のユーザーを指す Uid
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess                成功しました。
*   @retval     ResultTargetLocked           セーブデータが使用中です。
*   @retval     ResultMountNameAlreadyExists name で表されるファイルシステムが既に存在しています。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*       - nn::account::Initialize() でアカウントシステムのライブラリが初期化済みである。
*       - static_cast<bool>(user) == true
*       - user が指すユーザーアカウントが存在する。
*       - 対象のセーブデータが存在する。
*       - @link supported_filesystem サポートされているファイルシステム @endlink に記載されている同時にマウントできる数の上限を越えない。
*       - nmeta ファイルの NintendoSdkMeta/Core/FsAccessControlData/SaveDataOwnerIds に Id = applicationId, Accessibility = ReadWrite の要素が記述されている。
*/
Result MountSaveData(const char* name, nn::ApplicationId applicationId, const nn::account::Uid& user) NN_NOEXCEPT;



//! @}

}} // namespace nn::fs
