﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_TypesAdmin.h>
#include <nn/friends/friends_Macros.h>

namespace nn { namespace friends {

/*!
    @brief      いっしょに遊んだユーザーを扱うクラスです。

    detials
                いっしょに遊んだユーザーには、ユーザーのネットワークサービスアカウント ID と一緒に遊んだ記録が保存されます。@n
                ユーザープロフィールは、別途 @ref GetProfileList で取得する必要があります。
*/
class PlayHistory
{
public:
    /*!
        @brief      コンストラクタです。
    */
    PlayHistory() NN_NOEXCEPT;

    /*!
        @brief      ネットワークサービスアカウント ID を取得します。

        @return     ネットワークサービスアカウント ID。

        @details
                    @ref PlayHistory::HasNetworkServiceAccountId が false を返す場合、本関数で取得した ID を利用してはいけません。
    */
    nn::account::NetworkServiceAccountId GetAccountId() const NN_NOEXCEPT;

    /*!
        @brief      いっしょに遊んだ記録を取得します。

        @return     いっしょに遊んだ記録。
    */
    const PlayRecord& GetPlayRecord() const NN_NOEXCEPT;

    /*!
        @brief      ネットワークサービスアカウント ID を取得済みかどうかを確認します。

        @return     ネットワークサービスアカウント ID を取得済みかどうか。

        @details
                    いっしょに遊んだ時点で、相手がネットワークサービスアカウント ID を取得していたかどうかを確認することができます。@n
                    ネットワークサービスアカウント ID 未取得の相手に対して、フレンド申請やブロックを行うことはできません。
    */
    bool HasNetworkServiceAccountId() const NN_NOEXCEPT;

    /*!
        @brief      ローカルプレイでいっしょに遊んだかどうかを確認します。

        @return     ローカルプレイでいっしょに遊んだかどうか。
    */
    bool IsLocalPlayed() const NN_NOEXCEPT;

    /*!
        @brief      有効なデータを保持しているかどうかを確認します。

        @return     有効なデータを保持しているかどうか。
    */
    bool IsValid() const NN_NOEXCEPT;

private:
    //
    NN_FRIENDS_CLASS_STORAGE(256);
};

}}
