﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_TypesAdmin.h>
#include <nn/friends/friends_Macros.h>

namespace nn { namespace friends {

/*!
    @brief      フレンド候補を扱うクラスです。

    details
                フレンド候補を表示する時点では、相手のターゲットプラットフォーム内のプロフィールを表示してはいけません。（名寄せ対策）
*/
class FriendCandidate
{
public:
    /*!
        @brief      コンストラクタです。
    */
    FriendCandidate() NN_NOEXCEPT;

    /*!
        @brief      ネットワークサービスアカウント ID を取得します。

        @return     ネットワークサービスアカウント ID。
    */
    nn::account::NetworkServiceAccountId GetAccountId() const NN_NOEXCEPT;

    /*!
        @brief      フレンド候補の種類を取得します。

        @return     フレンド候補の種類。
    */
    FriendCandidateType GetType() const NN_NOEXCEPT;

    /*!
        @brief      推薦元アプリの外部アプリケーションのカタログ ID を取得します。

        @return     外部アプリケーションのカタログ ID。
    */
    const ExternalApplicationCatalogId& GetExternalApplicationCatalogId() const NN_NOEXCEPT;

    /*!
        @brief      いっしょに遊んだ記録を取得します。

        @return     いっしょに遊んだ記録。
    */
    const PlayRecord& GetPlayRecord() const NN_NOEXCEPT;

    /*!
        @brief      有効なデータを保持しているかどうかを確認します。

        @return     有効なデータを保持しているかどうか。
    */
    bool IsValid() const NN_NOEXCEPT;

private:
    //
    NN_FRIENDS_CLASS_STORAGE(256);
};

}}
