﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @brief   フレンド情報の表示及び操作に関連する UI を呼び出す処理で使用される型や定数の宣言(非公開)
*/

#pragma once

#include <nn/friends/friends_Types.h>

namespace nn { namespace friends {


/*!
    @brief アプレット起動モードを示す列挙子
*/
enum AppletMode
{
    AppletMode_ShowFriendList,                      //!< フレンド一覧画面の表示。
    AppletMode_ShowDetailInfo,                      //!< ユーザーの詳細画面の表示。
    AppletMode_StartSendingFriendRequest,           //!< フレンドリクエストの送信。
    AppletMode_ShowMethodsOfSendingFriendRequest,   //!< フレンドリクエストの送信手段一覧画面の表示。
    AppletMode_StartFacedFriendRequest,             //!< ローカル通信でフレンドリクエスト予約を開始。
    AppletMode_ShowReceivedFriendRequestList,       //!< 受信したフレンドリクエスト一覧画面の表示。
    AppletMode_ShowBlockedUserList,                 //!< ブロックリストの管理画面の表示。
    AppletMode_ShowMyProfile,                       //!< ユーザーアカウントの情報の表示。
};

/*!
    @brief アプレット起動時の引数
*/
struct AppletArg
{
    AppletMode mode;                                  //!< 起動モード。
    nn::account::Uid uid;                             //!< ユーザーアカウント。
    nn::account::NetworkServiceAccountId accountId;   //!< 相手のネットワークサービスアカウント ID。
    InAppScreenName myInAppScreenName;                //!< ユーザーアカウントのアプリ内表示名。
    InAppScreenName inAppScreenName;                  //!< 相手のアプリ内表示名。
};

}} // namespace nn::friends
