﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_Types.h>
#include <nn/friends/friends_Result.h>

namespace nn { namespace friends {

/*!
    @}
    @name いっしょに遊んだユーザー
    @{
*/

/*!
    @brief      任意のネットワークサービスアカウントをいっしょに遊んだユーザーの記録に登録するための登録キーを取得します。

    @param[out] outKey      登録キー。
    @param[in]  accountId   ネットワークサービスアカウント ID。
    @param[in]  isLocalPlay ローカル通信でいっしょに遊ぶかどうか。

    @return     処理結果。

    @pre
        - outKey != nullptr

    @details
                本関数は、ゲストログインユーザー（デバイスに紐付いていないニンテンドーアカウント）利用者向けです。@n
                ゲストログインユーザーを相手のいっしょに遊んだユーザーの記録に登録する場合、本関数を利用してください。

    @see
        - AddPlayHistory
*/
nn::Result GetPlayHistoryRegistrationKey(PlayHistoryRegistrationKey* outKey,
    nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT;

/*!
    @}
*/

}}
