﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace util {

/*!
    @brief      乱数を取得します。
*/
inline uint64_t GetRandom() NN_NOEXCEPT
{
    uint64_t value;
    nn::os::GenerateRandomBytes(&value, sizeof (value));

    return value;
}

}}}}}
