﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/ipc/friends_IServiceCreator.sfdl.h>
#include <nn/friends/detail/ipc/friends_ServiceConfig.h>
#include <nn/friends/detail/service/friends_ServiceHeap.h>

namespace nn { namespace friends { namespace detail { namespace service {

/*!
    @brief      サービス生成器です。
*/
class ServiceCreatorForGeneric
{
public:
    /*!
        @brief      FriendService に割り当てるバッファサイズです。
    */
    static const size_t FriendServiceSize = 2 * 1024;

    /*!
        @brief      FriendService のヒープサイズです。
    */
    static const size_t FriendServiceHeapSize = FriendServiceSize * detail::ipc::FriendServiceCountMax;

    /*!
        @brief      NotificationService に割り当てるバッファサイズです。
    */
    static const size_t NotificationServiceSize = 2 * 1024;

    /*!
        @brief      NotificationService のヒープサイズです。
    */
    static const size_t NotificationServiceHeapSize = NotificationServiceSize * detail::ipc::NotificationServiceCountMax;

    /*!
        @brief      DaemonSuspendSessionService に割り当てるバッファサイズです。
    */
    static const size_t DaemonSuspendSessionServiceSize = 128;

    /*!
        @brief      DaemonSuspendSessionService のヒープサイズです。
    */
    static const size_t DaemonSuspendSessionServiceHeapSize = DaemonSuspendSessionServiceSize * detail::ipc::DaemonSuspendSessionServiceCountMax;

public:
    /*!
        @brief      コンストラクタです。
    */
    ServiceCreatorForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~ServiceCreatorForGeneric() NN_NOEXCEPT;

public:
    // IServiceCreator
    nn::Result CreateFriendService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::IFriendService>> outService) NN_NOEXCEPT;
    nn::Result CreateNotificationService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::INotificationService>> outService, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result CreateDaemonSuspendSessionService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::IDaemonSuspendSessionService>> outService) NN_NOEXCEPT;

private:
    //
    ServiceHeap<FriendServiceHeapSize> m_FriendServiceHeap;
    ServiceHeap<NotificationServiceHeapSize> m_NotificationServiceHeap;
    ServiceHeap<DaemonSuspendSessionServiceHeapSize> m_DaemonSuspendSessionServiceHeap;
};

}}}}
