﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/ipc/friends_INotificationService.sfdl.h>
#include <nn/os.h>
#include <nn/account/account_Types.h>

namespace nn { namespace friends { namespace detail { namespace service {

/*!
    @brief      通知サービスです。
*/
class NotificationServiceForGeneric
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  uid ユーザーアカウント。
    */
    explicit NotificationServiceForGeneric(const nn::account::Uid& uid) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~NotificationServiceForGeneric() NN_NOEXCEPT;

public:
    // INotificationService
    nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result Clear() NN_NOEXCEPT;
    nn::Result Pop(nn::sf::Out<nn::friends::detail::ipc::SizedNotificationInfo> outInfo) NN_NOEXCEPT;

private:
    //
    nn::account::Uid m_Uid;
    //
    nn::os::SystemEvent m_Event;
    bool m_IsEventCreated;
};

}}}}
