﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/friends_Task.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      ユーザー設定を同期するタスクです。
*/
class SyncUserSettingTask : public Task
{
public:
    /*!
        @brief      コンストラクタです。
    */
    SyncUserSettingTask() NN_NOEXCEPT;

private:
    //
    bool m_IsSetDefaultPlayLogPermissionNeeded;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    PlayLog m_UploadPlayLogs[PlayLogCountMax];
    int m_UploadPlayLogCount;

private:
    //
    nn::Result StepSync() NN_NOEXCEPT;
    //
    nn::Result StepIssueFriendCode() NN_NOEXCEPT;
    //
    nn::Result StepSetDefaultPlayLogPermission() NN_NOEXCEPT;
    nn::Result CreateSetDefaultPlayLogPermissionPatch(char* buffer, size_t size) NN_NOEXCEPT;
    //
    nn::Result StepUploadPlayLog() NN_NOEXCEPT;
    nn::Result CreateUploadPlayLogPatch(char* buffer, size_t size) NN_NOEXCEPT;
};

}}}}}
