﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/friends_Task.h>
#include <nn/friends/detail/service/core/friends_FriendListManager.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンドリストを同期するタスクです。
*/
class SyncFriendListBaseTask : virtual public Task
{
protected:
    //
    nn::Result StepSyncFriendList() NN_NOEXCEPT;

private:
    //
    nn::Result StepUpdateFriendInfo() NN_NOEXCEPT;
    nn::Result CreateUpdateFriendInfoPatch(const FriendListManager::Record& record,
        char* buffer, size_t size) NN_NOEXCEPT;
    //
    nn::Result StepSyncFriendListImpl() NN_NOEXCEPT;
};

}}}}}
