﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/friends_Task.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      自分と相手ユーザー間の関係を取得するタスクです。
*/
class GetRelationshipTask : public Task
{
public:
    /*!
        @brief      コンストラクタです。
    */
    GetRelationshipTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[out] outRelationship 自分と相手ユーザー間の関係。
        @param[in]  accountId       相手のネットワークサービスアカウント ID。

        @return     処理結果。
    */
    nn::Result SetParameter(Relationship* outRelationship,
        nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    //
    Relationship* m_OutRelationship;
    nn::account::NetworkServiceAccountId m_AccountId;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepGet() NN_NOEXCEPT;
};

}}}}}
