﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/task/friends_TaskSyncFriendListBase.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンドを削除するタスクです。
*/
class DeleteFriendTask : public SyncFriendListBaseTask
{
public:
    /*!
        @brief      コンストラクタです。
    */
    DeleteFriendTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId   フレンドのネットワークサービスアカウント ID。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    //
    nn::account::NetworkServiceAccountId m_FriendAccountId;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepDelete() NN_NOEXCEPT;
};

}}}}}
