﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      ユーザーリソースのハンドラです。
*/
class UserResourceHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      ユーザーリソースのパース結果です。
    */
    struct UserResourceParseBits
    {
        Bit64 presencePermission : 1;
        Bit64 friendRequestReception : 1;
        Bit64 friendCode : 1;
        Bit64 friendCodeNextIssuableTime : 1;
        Bit64 accountId : 1;
        Bit64 nickname : 1;
        Bit64 profileImageUrl : 1;
        Bit64 playLog : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    UserResourceHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[in]  buffer  バッファ。
        @param[in]  size    バッファサイズ。

        @return     処理結果。

        @pre
            - buffer != nullptr
            - size >= sizeof (UserResource)
    */
    nn::Result Initialize(void* buffer, size_t size) NN_NOEXCEPT;

    /*!
        @brief      ユーザーリソースを取得します。

        @return     ユーザーリソース。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    const UserResource& GetResource() const NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnBoolean(const detail::service::json::JsonPath& jsonPath, bool value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    UserResource* m_Resource;
    UserResourceParseBits m_Bits;

private:
    //
    bool ParsePlayLog(const char* json, size_t length) NN_NOEXCEPT;
};

}}}}}
