﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      プレゼンスのハンドラです。
*/
class PresenceHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      コンストラクタです。
    */
    PresenceHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[in]  buffer  バッファ。
        @param[in]  size    バッファサイズ。

        @pre
            - buffer != nullptr
            - size > 0
    */
    void Initialize(char* buffer, size_t size) NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    char* m_Buffer;
    size_t m_Size;
};

}}}}}
