﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      プレイログのハンドラです。
*/
class PlayLogHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      プレイログのパース結果です。
    */
    struct PlayLogParseBits
    {
        Bit64 appId : 1;
        Bit64 presenceGroupId : 1;
        Bit64 totalPlayCount : 1;
        Bit64 totalPlayTime : 1;
        Bit64 firstPlayedTime : 1;
        Bit64 lastPlayedTime : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    PlayLogHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outPlayLogs プレイログリスト。
        @param[in]  num         要素数。

        @pre
            - playLogs != nullptr
            - num > 0
    */
    void Initialize(PlayLog* outPlayLogs, int num) NN_NOEXCEPT;

    /*!
        @brief      パースした個数を取得します。

        @return     パースした個数。
    */
    int GetCount() const NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndArray(const detail::service::json::JsonPath& jsonPath, size_t numElements) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    PlayLog* m_OutPlayLogs;
    int m_Index;
    int m_Num;
    //
    PlayLog m_PlayLog;
    PlayLogParseBits m_Bits;

private:
    //
    void AddOrMergePlayLog() NN_NOEXCEPT;
};

}}}}}
