﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      通知のハンドラです。
*/
class NotificationHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      通知のパース結果です。
    */
    struct NotificationParseBits
    {
        Bit64 type : 1;
        Bit64 accountId : 1;
        Bit64 presenceStatus : 1;
        Bit64 presenceAppId : 1;
        Bit64 presencePresenceGroupId : 1;
        Bit64 presenceLastUpdateTime : 1;
        Bit64 presenceAppField : 1;
        Bit64 presenceLogoutTime : 1;
        Bit64 creationTime : 1;
        Bit64 requestType : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    NotificationHandler() NN_NOEXCEPT;

    /*!
        @brief      通知種別を取得します。

        @return     通知種別。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    const char* GetType() const NN_NOEXCEPT;

    /*!
        @brief      通知を発行したユーザーのネットワークサービスアカウント ID を取得します。

        @return     ネットワークサービスアカウント ID。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    nn::account::NetworkServiceAccountId GetAccountId() const NN_NOEXCEPT;

    /*!
        @brief      フレンドプレゼンスを取得します。

        @return     フレンドプレゼンス。

        @details
                    通知種別が presence_updated でない場合、本関数が返す値は不定値となります。@n
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    const FriendPresenceImpl& GetFriendPresence() const NN_NOEXCEPT;

    /*!
        @brief      リクエスト種別を取得します。

        @return     リクエスト種別。

        @details
                    通知種別が friend_request_received でない場合、本関数が返す値は不定値となります。@n
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    RequestType GetRequestType() const NN_NOEXCEPT;

    /*!
        @brief      通知の作成時刻を取得します。

        @return     通知の作成時刻。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    const nn::time::PosixTime GetCreationTime() const NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    char m_Type[64];
    nn::account::NetworkServiceAccountId m_AccountId;
    //
    FriendPresenceImpl m_Presence;
    nn::time::PosixTime m_LogoutTime;
    nn::time::PosixTime m_CreationTime;
    //
    RequestType m_RequestType;
    //
    NotificationParseBits m_Bits;

private:
    //
    bool ParseFriendPresenceAppField(const char* json, size_t length) NN_NOEXCEPT;
};

}}}}}
