﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      NNID 情報のハンドラです。
*/
class NintendoNetworkIdInfoResourceHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      NNID ユーザー情報リソースのパース結果です。
    */
    struct NintendoNetworkIdUserInfoResourceParseBits
    {
        Bit64 miiName : 1;
        Bit64 miiImageUrlParam : 1;
        Bit64 friendCount : 1;
    };

    /*!
        @brief      3DS/Wii U 世代のフレンドリソースのパース結果です。
    */
    struct NintendoNetworkIdFriendResourceParseBits
    {
        Bit64 accountId : 1;
        Bit64 miiName : 1;
        Bit64 miiImageUrlParam : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    NintendoNetworkIdInfoResourceHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outUserInfo ユーザーアカウントに紐付く NNID のユーザー情報。
        @param[out] outCount    取得した数。
        @param[out] outFriends  フレンドリスト。
        @param[in]  count       フレンドリストの要素数。

        @pre
            - outUserInfo != nullptr
            - outCount != nullptr
            - outFriends != nullptr
            - count > 0
    */
    void Initialize(NintendoNetworkIdUserInfo* outUserInfo, int* outCount, NintendoNetworkIdFriendImpl* outFriends,
        int count) NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndArray(const detail::service::json::JsonPath& jsonPath, size_t numElements) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    NintendoNetworkIdUserInfo* m_OutUserInfo;
    int* m_OutCount;
    NintendoNetworkIdFriendImpl* m_OutFriends;
    int m_Count;
    //
    int m_Index;
    //
    NintendoNetworkIdUserInfoResourceParseBits m_UserInfoBits;
    //
    NintendoNetworkIdFriendImpl m_Friend;
    NintendoNetworkIdFriendResourceParseBits m_FriendBits;
};

}}}}}
