﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド申請リソースリストのハンドラです。
*/
class FriendRequestResourceListHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      フレンド申請リソースのパース結果です。
    */
    struct FriendRequestResourceParseBits
    {
        Bit64 requestId : 1;
        Bit64 accountId : 1;
        Bit64 nickname : 1;
        Bit64 profileImageUrl : 1;
        Bit64 requestType : 1;
        Bit64 requestStatus : 1;
        Bit64 appId : 1;
        Bit64 presenceGroupId : 1;
        Bit64 catalogId : 1;
        Bit64 miiName : 1;
        Bit64 miiImageUrlParam : 1;
        Bit64 inAppScreenName : 1;
        Bit64 language : 1;
        Bit64 registeredTime : 1;
        Bit64 read : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    FriendRequestResourceListHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outCount    取得した数。
        @param[out] outRequests フレンド申請リスト。
        @param[in]  uid         ユーザーアカウント。
        @param[in]  listType    フレンド申請リスト種別。
        @param[in]  count       フレンド申請リストの要素数。

        @pre
            - outCount ! =nullptr
            - outRequests ! =nullptr
            - count > 0
    */
    void Initialize(int* outCount, FriendRequestImpl* outRequests,
        const nn::account::Uid& uid, RequestListType listType, int count) NN_NOEXCEPT;

    /*!
        @brief      未読のフレンド申請件数を取得します。

        @return     未読のフレンド申請件数。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    int GetUnreadCount() const NN_NOEXCEPT;

    /*!
        @brief      既読のフレンド申請件数を取得します。

        @return     既読のフレンド申請件数。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    int GetReadCount() const NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndArray(const detail::service::json::JsonPath& jsonPath, size_t numElements) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnBoolean(const detail::service::json::JsonPath& jsonPath, bool value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::account::Uid m_Uid;
    RequestListType m_ListType;
    //
    int* m_OutCount;
    FriendRequestImpl* m_OutRequests;
    int m_Count;
    //
    int m_Index;
    //
    FriendRequestImpl m_Request;
    FriendRequestResourceParseBits m_Bits;
    //
    int m_ReadCount;
};

}}}}}
