﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド候補リソースリストのハンドラです。
*/
class FriendCandidateResourceListHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      フレンド候補リソースのパース結果です。
    */
    struct FriendCandidateResourceParseBits
    {
        Bit64 accountId : 1;
        Bit64 catalogId : 1;
        Bit64 playRecordAppId : 1;
        Bit64 playRecordName : 1;
        Bit64 playRecordMyName : 1;
        Bit64 playRecordTime : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    FriendCandidateResourceListHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outCount        取得した数。
        @param[out] outCandidates   フレンド候補リスト。
        @param[in]  count           フレンド候補リストの要素数。

        @pre
            - outCount != nullptr
            - outCandidates != nullptr
            - count > 0
    */
    void Initialize(int* outCount, FriendCandidateImpl* outCandidates,
        int count) NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndArray(const detail::service::json::JsonPath& jsonPath, size_t numElements) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    int* m_OutCount;
    FriendCandidateImpl* m_OutCandidates;
    int m_Count;
    //
    int m_Index;
    //
    FriendCandidateImpl m_Candidate;
    FriendCandidateResourceParseBits m_Bits;
};

}}}}}
