﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      ブロックしたユーザーリソースリストのハンドラです。
*/
class BlockedUserResourceListHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      ブロックしたユーザーリソースのパース結果です。
    */
    struct BlockedUserResourceParseBits
    {
        Bit64 accountId : 1;
        Bit64 nickname : 1;
        Bit64 profileImageUrl : 1;
        Bit64 blockReason : 1;
        Bit64 routeAppId : 1;
        Bit64 routePresenceGroupId : 1;
        Bit64 routeName : 1;
        Bit64 routeNameLanguage : 1;
        Bit64 routeTime : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    BlockedUserResourceListHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[in]  buffer  バッファ。
        @param[in]  size    バッファサイズ。

        @return     処理結果。

        @pre
            - buffer != nullptr
            - size >= sizeof (BlockedUserResource) * BlockedUserCountMax
    */
    nn::Result Initialize(void* buffer, size_t size) NN_NOEXCEPT;

    /*!
        @brief      ブロックしたユーザーリソースリストを取得します。

        @return     ブロックしたユーザーリソースリスト。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    const BlockedUserResource* GetResourceList() const NN_NOEXCEPT;

    /*!
        @brief      ブロックしたユーザーリソースリストの要素数を取得します。

        @return     ブロックしたユーザーリソースリストの要素数。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    int GetResourceCount() const NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    BlockedUserResource* m_Resources;
    int m_Count;
    //
    BlockedUserResourceParseBits m_Bits;
};

}}}}}
