﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>
#include <nn/friends/detail/service/friends_ServiceHeap.h>
#include <nn/friends/detail/ipc/friends_ServiceConfig.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      サービスのメモリ管理モジュールです。
*/
class ServiceMemoryManager
{
public:
    /*!
        @brief      FriendService に割り当てるバッファサイズです。
    */
    static const size_t FriendServiceSize = 4 * 1024;

    /*!
        @brief      FriendService のヒープサイズです。
    */
    static const size_t FriendServiceHeapSize = FriendServiceSize * detail::ipc::FriendServiceCountMax;

    /*!
        @brief      NotificationService に割り当てるバッファサイズです。
    */
    static const size_t NotificationServiceSize = 8 * 1024;

    /*!
        @brief      NotificationService のヒープサイズです。
    */
    static const size_t NotificationServiceHeapSize = NotificationServiceSize * detail::ipc::NotificationServiceCountMax;

    /*!
        @brief      DaemonSuspendSessionService に割り当てるバッファサイズです。
    */
    static const size_t DaemonSuspendSessionServiceSize = 128;

    /*!
        @brief      DaemonSuspendSessionService のヒープサイズです。
    */
    static const size_t DaemonSuspendSessionServiceHeapSize = DaemonSuspendSessionServiceSize * detail::ipc::DaemonSuspendSessionServiceCountMax;

private:
    /*!
        @brief      コンストラクタです。
    */
    ServiceMemoryManager() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static ServiceMemoryManager& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ServiceMemoryManager, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      FriendService 用アロケータを取得します。

        @return     FriendService 用アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetFriendServiceAllocator() NN_NOEXCEPT;

    /*!
        @brief      NotificationService 用アロケータを取得します。

        @return     NotificationService 用アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetNotificationServiceAllocator() NN_NOEXCEPT;

    /*!
        @brief      DaemonSuspendSessionService 用アロケータを取得します。

        @return     DaemonSuspendSessionService 用アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetDaemonSuspendSessionServiceAllocator() NN_NOEXCEPT;

private:
    //
    ServiceHeap<FriendServiceHeapSize> m_FriendServiceHeap;
    ServiceHeap<NotificationServiceHeapSize> m_NotificationServiceHeap;
    ServiceHeap<DaemonSuspendSessionServiceHeapSize> m_DaemonSuspendSessionServiceHeap;
};

}}}}}
